//
//  PPClipBusinessCardViewController.h
//
//
//  Created by Andrewlia on 13/12/25.
//  Copyright (c) 2013年 penpower. All rights reserved.
//


#import "PPViewController.h"

// Define
#import "PPClipBusinessCardViewControllerResourceDefine.h"
#import "PPClipBusinessCardViewControllerPublicParameterDefine.h"

// View
#import "PPBusyView.h"
#import "PPButton+Factory.h"
#import "PPImageScrollView.h"
#import "PPNavigationBarView.h"
#import "PPClipBusinessCardDrawSelectRectangleView.h"
#import "PPClipBusinessCardSelectRectangleImageScrollView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPClipBusinessCardViewController;
@protocol PPClipBusinessCardViewControllerDelegate <NSObject>
@required
- (void)ppClipBusinessCardViewController:(PPClipBusinessCardViewController *)ppClipBusinessCardViewController ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent;
@optional
- (void)ppClipBusinessCardViewController:(PPClipBusinessCardViewController *)ppClipBusinessCardViewController rotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

- (void)ppClipBusinessCardViewController:(PPClipBusinessCardViewController *)ppClipBusinessCardViewController willAnimateRotationToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPClipBusinessCardViewController : PPViewController<PPButtonDelegate, PPClipBusinessCardSelectRectangleImageScrollViewDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<PPClipBusinessCardViewControllerDelegate>   delegate;
@property (nonatomic,retain) NSString                                       *navigationBarTitle;
@property (nonatomic,assign) PPBarViewStyle                                 defaultNavigationBarStyle;  //default PPBarViewStyle_CenteredAbsolute
@property (nonatomic,retain) NSString                                       *recognitionButtonTitle;
@property (nonatomic,retain) UIImage                                        *clipImage;
@property (nonatomic,retain) UIImage                                        *frontCardImage;
@property (nonatomic,retain) UIImage                                        *rearCardImage;
@property (nonatomic,assign) CGFloat                                        bottomBarHeight;
@property (nonatomic,assign) CGFloat                                        maximumZoomScale;
@property (nonatomic,assign) CGRect                                         sourceImageSelectRect;
@property (nonatomic,assign) NSInteger                                      recognitionLanguageType;
@property (nonatomic,assign) PPClipBusinessCardViewControllerStyle          ppClipBusinessCardViewControllerStyle;
//變換底部按鈕的配色
@property (nonatomic,retain) UIColor                                        *contentBackgroundColor;
@property (nonatomic,retain) UIColor                                        *bottomToolBarButtonBackgroundColorNormal;
@property (nonatomic,retain) UIColor                                        *bottomToolBarButtonBackgroundColorHighlighted;
@property (nonatomic,retain) UIColor                                        *bottomToolBarLanguageTextColorNormal;
@property (nonatomic,retain) UIColor                                        *bottomToolBarLanguageTextColorHighlighted;
@property (nonatomic,retain) UIColor                                        *navigationBarButtonBackgroundColorHighlighted;
@property (nonatomic,assign) PPClipBusinessCardViewControllerClipImageSide  clipImageSide;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (void)showBusyView:(BOOL)show superView:(UIView *)superView;

@end
