//
//  PPCardImageViewController.h
//  
//
//  Created by Howard.Lin on 13/12/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPImageBrowseViewController.h"

// Define
#import "PPCardImageViewController+PublicParameterDefine.h"
#import "PPCardImageViewControllerDelegate.h"
#import "PPCardImageViewControllerDatasource.h"

// View
#import "CardImageBottomBarView.h"
#import "CardImageTopBarView.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCardImageViewController : PPImageBrowseViewController <UIActionSheetDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)             id<PPCardImageViewControllerDatasource> datasource;
@property (nonatomic,assign)             id<PPCardImageViewControllerDelegate>   delegate;
@property (nonatomic,assign)             PPCardImageViewControllerDisplayMode    cardImageViewControllerDisplayMode;
@property (nonatomic,readonly)           PPCardImageViewControllerAction         cardImageViewControllerAction;
@property (nonatomic,readonly)           CardImageBottomBarView                  *cardImageBottomBarView;
@property (nonatomic,readonly)           CardImageTopBarView                     *cardImageTopBarView;
@property (nonatomic,assign)             BOOL                                    rearCardImageFixed;
@property (nonatomic,assign)             BOOL                                    frontCardImageFixed;
@property (nonatomic,assign)             BOOL                                    againRecognition;
@property (nonatomic,readonly)           UIImage                                 *rearCardImage;
@property (nonatomic,readonly)           UIImage                                 *frontCardImage;
// 視圖標題
@property (nonatomic,copy)               NSString                                *controllerTitle;
// 下方工具列底色
@property (nonatomic,retain)             UIColor                                 *bottomBarBackgroundColor;
@property (nonatomic,retain)             UIColor                                 *bottomBarBacButtonHighlightedkgroundColor;
// 捲動視圖底色
@property (nonatomic,retain)             UIColor                                 *imageScrollViewBackgroundColor DEPRECATED_ATTRIBUTE;
//　上方工具列按鈕，highlighted 狀態底色
@property (nonatomic,retain)             UIColor                                 *navigationBarButtonHighlightedBackgroundColor;
@property (nonatomic,assign)             UIEdgeInsets                            buttonImageEdgeInsets;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/// 目前的面頁是否有圖
- (BOOL)hasImage;

- (UIImage *)displayImage;

- (void)clearMember;
@end
