//
//  MetalFunctionCreateMapping.h
//  Extension
//
//  Created by sanhue cheng on 2020/5/29.
//

#import <Foundation/Foundation.h>
#import <Metal/Metal.h>

NS_ASSUME_NONNULL_BEGIN

@interface MetalFunctionCreateMapping : NSObject

- (nullable instancetype)initWithDevice:(nonnull id <MTLDevice>)device libray:(nonnull id<MTLLibrary>)library;

- (void)encodeToCommandBuffer:(nonnull id <MTLCommandBuffer>)commandBuffer
            withStartPosition:(CGPoint)startPosition
                 stopPosition:(CGPoint)stopPosition
                       median:(int)median
                sourceTexture:(id<MTLTexture>)sourceTexture
                resultTexture:(id<MTLTexture>)resultTexture
                    imageSize:(CGSize)imageSize;

@end

NS_ASSUME_NONNULL_END
