//
//  PPBarViewItemModel.h
//  
//
//  Created by Mike on 13/5/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPBarViewItemModelDefaultEdgeInsertsForMiniBar    UIEdgeInsetsMake(4, 2.5, 4, 2.5)
#define PPBarViewItemModelDefaultEdgeInsertsForNormalBar  UIEdgeInsetsMake(7, 2.5, 7, 2.5)

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPBarViewItemModel : NSObject 
{
@private
    UIView          *view_;
    UIEdgeInsets    edgeInsetsForMiniBar_;
    UIEdgeInsets    edgeInsetsForNormalBar_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,retain) UIView *view;
@property(nonatomic,assign) UIEdgeInsets    edgeInsetsForMiniBar;
@property(nonatomic,assign) UIEdgeInsets    edgeInsetsForNormalBar;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (UIColor *)tintColor;
- (void)setTintColor:(UIColor *)tintColor;
- (UIEdgeInsets)edgeInsetsForMiniBarState:(BOOL)miniBarState;
- (void)setEdgeInsets:(UIEdgeInsets)edgeInsets forMiniBarState:(BOOL)miniBarState;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (id)ppBarViewItemModelWithView:(UIView *)view;

@end
