//
//  PPBarViewBlockModel.h
//  
//
//  Created by Mike on 13/5/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPBarViewItemModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPBarViewBlockModelDefaultEdgeInsertsForMiniBar     UIEdgeInsetsMake(0, 2.5, 0, 2.5)
#define PPBarViewBlockModelDefaultEdgeInsertsForNormalBar   PPBarViewBlockModelDefaultEdgeInsertsForMiniBar

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPBarViewBlockModel : NSObject 
{
@private
    NSMutableArray  *itemModels_;
    UIEdgeInsets    edgeInsetsForMiniBar_;
    UIEdgeInsets    edgeInsetsForNormalBar_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,readonly)   NSMutableArray  *itemModels;
@property(nonatomic,assign)     UIEdgeInsets    edgeInsetsForMiniBar;
@property(nonatomic,assign)     UIEdgeInsets    edgeInsetsForNormalBar;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (UIEdgeInsets)edgeInsetsForMiniBarState:(BOOL)miniBarState;
- (void)setEdgeInsets:(UIEdgeInsets)edgeInsets forMiniBarState:(BOOL)miniBarState;

@end
