//
//  PPBarView.h
//  
//
//  Created by Mike on 13/5/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//
//  2015/12/30-確認後續App橫式皆將NavigationBar客製化為Normal高度，所以將MiniBar相關移除
//             元件內部會對所有內容預設EdgeInset(會導致呈現Size變小)，可以透過+(void)setIgnoreEdgeInset:(BOOL)ignoreEdgeInset忽略預設的EdgeInset

#import <UIKit/UIKit.h>
#import "PPBarViewBlockModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPBarViewDefaultHeightForNavigationBarMini      32
#define PPBarViewDefaultHeightForNavigationBarNormal    44
#define PPBarViewDefaultHeightForTabBar                 49
#define PPBarViewDefaultHeightForToolBar                44

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Resource

extern NSString *ImageNamePPBarViewBackgroundForNavigationBar;
extern NSString *ImageNamePPBarViewBackgroundForTabBar;
extern NSString *ImageNamePPBarViewBackgroundForToolBar;

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPBarViewStyle)
{
	PPBarViewStyle_Default = 0,         //不重新排列所有subviews
	PPBarViewStyle_Average,             //每一個View的大小都設成相同
	PPBarViewStyle_CenteredAbsolute,	//中央區View絕對置中於整個Bar[中央區大於右邊或下邊會被自動截斷]
	PPBarViewStyle_CenteredRelative,	//中央區View相對置中於整個Bar[中央區大於右邊或下邊會被自動截斷]
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPBarViewBlockType)
{
    PPBarViewBlockType_Left     = 0,
    PPBarViewBlockType_Center   = 1,
	PPBarViewBlockType_Right    = 2,
    PPBarViewBlockType_Top      = PPBarViewBlockType_Left,
    PPBarViewBlockType_Bottom   = PPBarViewBlockType_Right,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPBarView : UIView 
{
@protected
    NSMutableDictionary     *blockModels_;
    UIColor                 *tintColor_;
    UIImageView             *backgroundImageView_;
    
    PPBarViewStyle          style_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,retain)     UIColor                 *tintColor;
@property(nonatomic,readonly)   UIImageView             *backgroundImageView;
@property(nonatomic,assign)     PPBarViewStyle          style;

/// default NO, if YES, ignore edge inset setting in block model or item model
@property(nonatomic,assign)     BOOL                    ignoreEdgeInset;

@property(nonatomic,assign)      UIEdgeInsets addtionBlockEdgeInsets;

@property(nonatomic,retain,readonly)   UIView *bottomLineView;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (PPBarViewBlockModel *)blockModelForType:(PPBarViewBlockType)type;
- (BOOL)setBlockModel:(PPBarViewBlockModel *)blockModel forType:(PPBarViewBlockType)type;
- (BOOL)setItemModels:(NSArray *)itemModels forBlockType:(PPBarViewBlockType)blockType;
- (BOOL)setViews:(NSArray *)views forBlockType:(PPBarViewBlockType)blockType;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - preferance methods
+ (void)setBarBackgroundColor:(UIColor *)color;
+ (UIColor *)barBackgroundColor;

/// default NO, if YES, ignore edge inset setting in block model or item model
+ (void)setIgnoreEdgeInset:(BOOL)ignoreEdgeInset;
+ (BOOL)ignoreEdgeInset;

+ (void)setTitleTextColor:(UIColor *)titleTextColor;
+ (UIColor *)titleTextColor;

@end
