//
//  AlbumImageFileController.h
//
//  Created by howard.lin on 13/3/14.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Photos/Photos.h>


////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, AlbumImageFileControllerAssetSelection)
{
    AlbumImageFileControllerAssetSelection_FullResolutionImage,
    AlbumImageFileControllerAssetSelection_FullScreenImage,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface AlbumImageFileController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/// get items in the "appSandboxDirectory" folder
+ (NSMutableArray *)itemArrayWithAppSandboxDirectory:(NSString *)appSandboxDirectory;

/// get image with file path
+ (UIImage *)imageFilePath:(NSString *)filePath withFileName:(NSString *)fileName;
+ (UIImage *)imageWithAbsolutePath:(NSString *)filePath;


#pragma mark - Photos Method

+ (PHPhotoLibrary *)defaultPhotoLibrary;

+ (NSMutableArray *)itemArrayWithAssetCollection:(PHAssetCollection*)assetCollection;

/// 取得相簿封面
+ (void)fetchPosterImageWithAssetCollection:(PHAssetCollection *)assetCollection  completeHandler:(void(^)(UIImage *result))completeHandler;

/// 取得指定大小的圖片, targetSize設為CGSizeMake(perAsset.pixelWidth, perAsset.pixelHeight)可取原圖
+ (void)fetchImageWithPHAsset:(PHAsset *)asset targetSize:(CGSize)targetSize completeHandler:(void(^)(UIImage *result))completeHandler;

/// 取得縮圖 CGSizeMake(150,150)
+ (void)fetchThumbnailImageWithPHAsset:(PHAsset *)asset completeHandler:(void(^)(UIImage *result))completeHandler;

@end
