//
//  PPAboutViewController.h
//
//  Created by Mike Shih on 12/6/7.
//  Extracted by Andrew Lai on 14/2/5.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "NSString+Additions.h"
#import "PPButton.h"
#import "PPHyperLinkLabel.h"
#import "PPNavigationBarView.h"
#import "PPViewController.h"
#import "UIColor+PropertyDictionary.h"
#import "UIView+Appearance.h"
#import "PPBarViewItemModel.h"
#import "PPBarViewBlockModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 需給予Icon圖式

#define PPFileNameAboutViewControllerForIOS7iPhone  @"AppIcon60x60@2x"  // iPhone and iPod touch style UI
#define PPFileNameAboutViewControllerForIOS7iPad    @"AppIcon76x76@2x"  // iPad style UI
#define PPFileNameAboutViewControllerForIOS6iPhone  @"AppIcon57x57"  // iPhone and iPod touch style UI
#define PPFileNameAboutViewControllerForIOS6iPad    @"AppIcon72x72"  // iPad style UI

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPAboutViewController;

@protocol PPAboutViewControllerDelegate <NSObject>

@optional
- (void)didTripleTapApplicationIconWithAboutViewController:(PPAboutViewController *)aboutViewController;
- (void)didTripleTapVersionLabelWithAboutViewController:(PPAboutViewController *)aboutViewController;
@end



////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPAboutViewController : PPViewController <PPButtonDelegate, PPHyperLinkLabelDelegate>
{
 @private
    NSString            *applicationNameLabelString_;
    NSString            *copyrightDateString_;
    NSString            *HyperLinkLabelURL_;
    NSString            *HyperLinkLabelDisplayString_;
    
    PPButton            *ppButtonBack_;
    PPHyperLinkLabel    *ppHyperLinkLabel_;
    PPNavigationBarView *ppNavigationBarView_;
    UIImageView			*applicationIconImageView_;
    UILabel				*allRightsReservedLabel_;
    UILabel				*applicationNameLabel_;
    UILabel				*companyNameLabel_;
	UILabel				*copyrightLabel_;
	UILabel				*versionNumberLabel_;
    UILabel             *kernelNumberLabel_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) id<PPAboutViewControllerDelegate> delegate;
@property (nonatomic, retain) NSString *applicationNameLabelString; //給予外部設定appName, 預設nil->抓bundle
@property (nonatomic, retain) NSString *copyrightDateString; //給予外部設定copyright顯示字串
@property (nonatomic, retain) NSString *HyperLinkLabelURL; //給予外部設定要連結的網址,預設nil->http://www.penpowerinc.com
@property (nonatomic, retain) NSString *HyperLinkLabelDisplayString; //給予外部設定界面上要顯示的連結字串,預設nil->抓domain
@property (nonatomic, retain) NSString *aboutViewControllerCompanyName;
@property (nonatomic, retain) NSString *aboutViewControllerAllRightsReserved;
@property (nonatomic, retain) NSString *versionCustom;// default is nil, 若非nil,則直接顯示該字串於頁面上
@property (nonatomic, retain) NSString *kernelCustom;// default is nil, 若非nil,則直接顯示該字串於頁面上
@property (nonatomic, retain) NSString *controllTitle;
@property (nonatomic, assign) BOOL     customNavigationBar; //預設YES,是否客製化NavigationBar

@property (nonatomic, retain) UIColor *navigationTitleColor;

#pragma mark - Attributed string
@property (nonatomic, retain) NSAttributedString *applicationNameAttributedString; //給予外部設定appName, 預設nil->取applicationNameLabelString

@property (nonatomic, retain) NSString *logoImageName;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (void)setDefaultBackButton:(PPButton *)backButton;

@end
