///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMUserAddResult;
@class DBTEAMUserSecondaryEmailsResult;
@class DBTEAMUserSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UserAddResult` union.
///
/// Result of trying to add secondary emails to a user. 'success' is the only
/// value indicating that a user was successfully retrieved for adding secondary
/// emails. The other values explain the type of error that occurred, and
/// include the user for which the error occured.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMUserAddResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMUserAddResultTag` enum type represents the possible tag states
/// with which the `DBTEAMUserAddResult` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMUserAddResultTag){
    /// Describes a user and the results for each attempt to add a secondary
    /// email.
    DBTEAMUserAddResultSuccess,

    /// Specified user is not a valid target for adding secondary emails.
    DBTEAMUserAddResultInvalidUser,

    /// Secondary emails can only be added to verified users.
    DBTEAMUserAddResultUnverified,

    /// Secondary emails cannot be added to placeholder users.
    DBTEAMUserAddResultPlaceholderUser,

    /// (no description).
    DBTEAMUserAddResultOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMUserAddResultTag tag;

/// Describes a user and the results for each attempt to add a secondary email.
/// @note Ensure the `isSuccess` method returns true before accessing, otherwise
/// a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMUserSecondaryEmailsResult *success;

/// Specified user is not a valid target for adding secondary emails. @note
/// Ensure the `isInvalidUser` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMUserSelectorArg *invalidUser;

/// Secondary emails can only be added to verified users. @note Ensure the
/// `isUnverified` method returns true before accessing, otherwise a runtime
/// exception will be raised.
@property (nonatomic, readonly) DBTEAMUserSelectorArg *unverified;

/// Secondary emails cannot be added to placeholder users. @note Ensure the
/// `isPlaceholderUser` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMUserSelectorArg *placeholderUser;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "success".
///
/// Description of the "success" tag state: Describes a user and the results for
/// each attempt to add a secondary email.
///
/// @param success Describes a user and the results for each attempt to add a
/// secondary email.
///
/// @return An initialized instance.
///
- (instancetype)initWithSuccess:(DBTEAMUserSecondaryEmailsResult *)success;

///
/// Initializes union class with tag state of "invalid_user".
///
/// Description of the "invalid_user" tag state: Specified user is not a valid
/// target for adding secondary emails.
///
/// @param invalidUser Specified user is not a valid target for adding secondary
/// emails.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidUser:(DBTEAMUserSelectorArg *)invalidUser;

///
/// Initializes union class with tag state of "unverified".
///
/// Description of the "unverified" tag state: Secondary emails can only be
/// added to verified users.
///
/// @param unverified Secondary emails can only be added to verified users.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnverified:(DBTEAMUserSelectorArg *)unverified;

///
/// Initializes union class with tag state of "placeholder_user".
///
/// Description of the "placeholder_user" tag state: Secondary emails cannot be
/// added to placeholder users.
///
/// @param placeholderUser Secondary emails cannot be added to placeholder
/// users.
///
/// @return An initialized instance.
///
- (instancetype)initWithPlaceholderUser:(DBTEAMUserSelectorArg *)placeholderUser;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "success".
///
/// @note Call this method and ensure it returns true before accessing the
/// `success` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "success".
///
- (BOOL)isSuccess;

///
/// Retrieves whether the union's current tag state has value "invalid_user".
///
/// @note Call this method and ensure it returns true before accessing the
/// `invalidUser` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "invalid_user".
///
- (BOOL)isInvalidUser;

///
/// Retrieves whether the union's current tag state has value "unverified".
///
/// @note Call this method and ensure it returns true before accessing the
/// `unverified` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "unverified".
///
- (BOOL)isUnverified;

///
/// Retrieves whether the union's current tag state has value
/// "placeholder_user".
///
/// @note Call this method and ensure it returns true before accessing the
/// `placeholderUser` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "placeholder_user".
///
- (BOOL)isPlaceholderUser;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMUserAddResult` union.
///
@interface DBTEAMUserAddResultSerializer : NSObject

///
/// Serializes `DBTEAMUserAddResult` instances.
///
/// @param instance An instance of the `DBTEAMUserAddResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMUserAddResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMUserAddResult *)instance;

///
/// Deserializes `DBTEAMUserAddResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMUserAddResult` API object.
///
/// @return An instantiation of the `DBTEAMUserAddResult` object.
///
+ (DBTEAMUserAddResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
