///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMRemovedStatus;
@class DBTEAMTeamMemberStatus;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamMemberStatus` union.
///
/// The user's status as a member of a specific team.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMTeamMemberStatus : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMTeamMemberStatusTag` enum type represents the possible tag states
/// with which the `DBTEAMTeamMemberStatus` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMTeamMemberStatusTag){
    /// User has successfully joined the team.
    DBTEAMTeamMemberStatusActive,

    /// User has been invited to a team, but has not joined the team yet.
    DBTEAMTeamMemberStatusInvited,

    /// User is no longer a member of the team, but the account can be
    /// un-suspended, re-establishing the user as a team member.
    DBTEAMTeamMemberStatusSuspended,

    /// User is no longer a member of the team. Removed users are only listed
    /// when include_removed is true in members/list.
    DBTEAMTeamMemberStatusRemoved,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMTeamMemberStatusTag tag;

/// User is no longer a member of the team. Removed users are only listed when
/// include_removed is true in members/list. @note Ensure the `isRemoved` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMRemovedStatus *removed;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "active".
///
/// Description of the "active" tag state: User has successfully joined the
/// team.
///
/// @return An initialized instance.
///
- (instancetype)initWithActive;

///
/// Initializes union class with tag state of "invited".
///
/// Description of the "invited" tag state: User has been invited to a team, but
/// has not joined the team yet.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvited;

///
/// Initializes union class with tag state of "suspended".
///
/// Description of the "suspended" tag state: User is no longer a member of the
/// team, but the account can be un-suspended, re-establishing the user as a
/// team member.
///
/// @return An initialized instance.
///
- (instancetype)initWithSuspended;

///
/// Initializes union class with tag state of "removed".
///
/// Description of the "removed" tag state: User is no longer a member of the
/// team. Removed users are only listed when include_removed is true in
/// members/list.
///
/// @param removed User is no longer a member of the team. Removed users are
/// only listed when include_removed is true in members/list.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemoved:(DBTEAMRemovedStatus *)removed;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "active".
///
/// @return Whether the union's current tag state has value "active".
///
- (BOOL)isActive;

///
/// Retrieves whether the union's current tag state has value "invited".
///
/// @return Whether the union's current tag state has value "invited".
///
- (BOOL)isInvited;

///
/// Retrieves whether the union's current tag state has value "suspended".
///
/// @return Whether the union's current tag state has value "suspended".
///
- (BOOL)isSuspended;

///
/// Retrieves whether the union's current tag state has value "removed".
///
/// @note Call this method and ensure it returns true before accessing the
/// `removed` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "removed".
///
- (BOOL)isRemoved;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMTeamMemberStatus` union.
///
@interface DBTEAMTeamMemberStatusSerializer : NSObject

///
/// Serializes `DBTEAMTeamMemberStatus` instances.
///
/// @param instance An instance of the `DBTEAMTeamMemberStatus` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMTeamMemberStatus` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamMemberStatus *)instance;

///
/// Deserializes `DBTEAMTeamMemberStatus` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMTeamMemberStatus` API object.
///
/// @return An instantiation of the `DBTEAMTeamMemberStatus` object.
///
+ (DBTEAMTeamMemberStatus *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
