///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESSsoPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SsoPolicy` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMPOLICIESSsoPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMPOLICIESSsoPolicyTag` enum type represents the possible tag
/// states with which the `DBTEAMPOLICIESSsoPolicy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMPOLICIESSsoPolicyTag){
    /// Users will be able to sign in with their Dropbox credentials.
    DBTEAMPOLICIESSsoPolicyDisabled,

    /// Users will be able to sign in with either their Dropbox or single
    /// sign-on credentials.
    DBTEAMPOLICIESSsoPolicyOptional,

    /// Users will be required to sign in with their single sign-on credentials.
    DBTEAMPOLICIESSsoPolicyRequired,

    /// (no description).
    DBTEAMPOLICIESSsoPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMPOLICIESSsoPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disabled".
///
/// Description of the "disabled" tag state: Users will be able to sign in with
/// their Dropbox credentials.
///
/// @return An initialized instance.
///
- (instancetype)initWithDisabled;

///
/// Initializes union class with tag state of "optional".
///
/// Description of the "optional" tag state: Users will be able to sign in with
/// either their Dropbox or single sign-on credentials.
///
/// @return An initialized instance.
///
- (instancetype)initWithOptional;

///
/// Initializes union class with tag state of "required".
///
/// Description of the "required" tag state: Users will be required to sign in
/// with their single sign-on credentials.
///
/// @return An initialized instance.
///
- (instancetype)initWithRequired;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disabled".
///
/// @return Whether the union's current tag state has value "disabled".
///
- (BOOL)isDisabled;

///
/// Retrieves whether the union's current tag state has value "optional".
///
/// @return Whether the union's current tag state has value "optional".
///
- (BOOL)isOptional;

///
/// Retrieves whether the union's current tag state has value "required".
///
/// @return Whether the union's current tag state has value "required".
///
- (BOOL)isRequired;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMPOLICIESSsoPolicy` union.
///
@interface DBTEAMPOLICIESSsoPolicySerializer : NSObject

///
/// Serializes `DBTEAMPOLICIESSsoPolicy` instances.
///
/// @param instance An instance of the `DBTEAMPOLICIESSsoPolicy` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESSsoPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSsoPolicy *)instance;

///
/// Deserializes `DBTEAMPOLICIESSsoPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESSsoPolicy` API object.
///
/// @return An instantiation of the `DBTEAMPOLICIESSsoPolicy` object.
///
+ (DBTEAMPOLICIESSsoPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
