///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESSmartSyncPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SmartSyncPolicy` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMPOLICIESSmartSyncPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMPOLICIESSmartSyncPolicyTag` enum type represents the possible tag
/// states with which the `DBTEAMPOLICIESSmartSyncPolicy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMPOLICIESSmartSyncPolicyTag){
    /// The specified content will be synced as local files by default.
    DBTEAMPOLICIESSmartSyncPolicyLocal,

    /// The specified content will be synced as on-demand files by default.
    DBTEAMPOLICIESSmartSyncPolicyOnDemand,

    /// (no description).
    DBTEAMPOLICIESSmartSyncPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMPOLICIESSmartSyncPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "local".
///
/// Description of the "local" tag state: The specified content will be synced
/// as local files by default.
///
/// @return An initialized instance.
///
- (instancetype)initWithLocal;

///
/// Initializes union class with tag state of "on_demand".
///
/// Description of the "on_demand" tag state: The specified content will be
/// synced as on-demand files by default.
///
/// @return An initialized instance.
///
- (instancetype)initWithOnDemand;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "local".
///
/// @return Whether the union's current tag state has value "local".
///
- (BOOL)isLocal;

///
/// Retrieves whether the union's current tag state has value "on_demand".
///
/// @return Whether the union's current tag state has value "on_demand".
///
- (BOOL)isOnDemand;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMPOLICIESSmartSyncPolicy` union.
///
@interface DBTEAMPOLICIESSmartSyncPolicySerializer : NSObject

///
/// Serializes `DBTEAMPOLICIESSmartSyncPolicy` instances.
///
/// @param instance An instance of the `DBTEAMPOLICIESSmartSyncPolicy` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESSmartSyncPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSmartSyncPolicy *)instance;

///
/// Deserializes `DBTEAMPOLICIESSmartSyncPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESSmartSyncPolicy` API object.
///
/// @return An instantiation of the `DBTEAMPOLICIESSmartSyncPolicy` object.
///
+ (DBTEAMPOLICIESSmartSyncPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
