///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMMembersListResult;
@class DBTEAMTeamMemberInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MembersListResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMembersListResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// List of team members.
@property (nonatomic, readonly) NSArray<DBTEAMTeamMemberInfo *> *members;

/// Pass the cursor into `membersListContinue` to obtain the additional members.
@property (nonatomic, readonly, copy) NSString *cursor;

/// Is true if there are additional team members that have not been returned
/// yet. An additional call to `membersListContinue` can retrieve them.
@property (nonatomic, readonly) NSNumber *hasMore;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param members List of team members.
/// @param cursor Pass the cursor into `membersListContinue` to obtain the
/// additional members.
/// @param hasMore Is true if there are additional team members that have not
/// been returned yet. An additional call to `membersListContinue` can retrieve
/// them.
///
/// @return An initialized instance.
///
- (instancetype)initWithMembers:(NSArray<DBTEAMTeamMemberInfo *> *)members
                         cursor:(NSString *)cursor
                        hasMore:(NSNumber *)hasMore;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MembersListResult` struct.
///
@interface DBTEAMMembersListResultSerializer : NSObject

///
/// Serializes `DBTEAMMembersListResult` instances.
///
/// @param instance An instance of the `DBTEAMMembersListResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMembersListResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersListResult *)instance;

///
/// Deserializes `DBTEAMMembersListResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMembersListResult` API object.
///
/// @return An instantiation of the `DBTEAMMembersListResult` object.
///
+ (DBTEAMMembersListResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
