///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLegalHoldStatus;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldStatus` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLegalHoldStatus : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLegalHoldStatusTag` enum type represents the possible tag states
/// with which the `DBTEAMLegalHoldStatus` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLegalHoldStatusTag){
    /// The legal hold policy is active.
    DBTEAMLegalHoldStatusActive,

    /// The legal hold policy was released.
    DBTEAMLegalHoldStatusReleased,

    /// The legal hold policy is activating.
    DBTEAMLegalHoldStatusActivating,

    /// The legal hold policy is updating.
    DBTEAMLegalHoldStatusUpdating,

    /// The legal hold policy is exporting.
    DBTEAMLegalHoldStatusExporting,

    /// The legal hold policy is releasing.
    DBTEAMLegalHoldStatusReleasing,

    /// (no description).
    DBTEAMLegalHoldStatusOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLegalHoldStatusTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "active".
///
/// Description of the "active" tag state: The legal hold policy is active.
///
/// @return An initialized instance.
///
- (instancetype)initWithActive;

///
/// Initializes union class with tag state of "released".
///
/// Description of the "released" tag state: The legal hold policy was released.
///
/// @return An initialized instance.
///
- (instancetype)initWithReleased;

///
/// Initializes union class with tag state of "activating".
///
/// Description of the "activating" tag state: The legal hold policy is
/// activating.
///
/// @return An initialized instance.
///
- (instancetype)initWithActivating;

///
/// Initializes union class with tag state of "updating".
///
/// Description of the "updating" tag state: The legal hold policy is updating.
///
/// @return An initialized instance.
///
- (instancetype)initWithUpdating;

///
/// Initializes union class with tag state of "exporting".
///
/// Description of the "exporting" tag state: The legal hold policy is
/// exporting.
///
/// @return An initialized instance.
///
- (instancetype)initWithExporting;

///
/// Initializes union class with tag state of "releasing".
///
/// Description of the "releasing" tag state: The legal hold policy is
/// releasing.
///
/// @return An initialized instance.
///
- (instancetype)initWithReleasing;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "active".
///
/// @return Whether the union's current tag state has value "active".
///
- (BOOL)isActive;

///
/// Retrieves whether the union's current tag state has value "released".
///
/// @return Whether the union's current tag state has value "released".
///
- (BOOL)isReleased;

///
/// Retrieves whether the union's current tag state has value "activating".
///
/// @return Whether the union's current tag state has value "activating".
///
- (BOOL)isActivating;

///
/// Retrieves whether the union's current tag state has value "updating".
///
/// @return Whether the union's current tag state has value "updating".
///
- (BOOL)isUpdating;

///
/// Retrieves whether the union's current tag state has value "exporting".
///
/// @return Whether the union's current tag state has value "exporting".
///
- (BOOL)isExporting;

///
/// Retrieves whether the union's current tag state has value "releasing".
///
/// @return Whether the union's current tag state has value "releasing".
///
- (BOOL)isReleasing;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLegalHoldStatus` union.
///
@interface DBTEAMLegalHoldStatusSerializer : NSObject

///
/// Serializes `DBTEAMLegalHoldStatus` instances.
///
/// @param instance An instance of the `DBTEAMLegalHoldStatus` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldStatus` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldStatus *)instance;

///
/// Deserializes `DBTEAMLegalHoldStatus` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldStatus` API object.
///
/// @return An instantiation of the `DBTEAMLegalHoldStatus` object.
///
+ (DBTEAMLegalHoldStatus *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
