///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLegalHoldHeldRevisionMetadata;
@class DBTEAMTeamMemberStatus;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldHeldRevisionMetadata` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLegalHoldHeldRevisionMetadata : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The held revision filename.
@property (nonatomic, readonly, copy) NSString *dNewFilename;

/// The id of the held revision.
@property (nonatomic, readonly, copy) NSString *originalRevisionId;

/// The original path of the held revision.
@property (nonatomic, readonly, copy) NSString *originalFilePath;

/// The last time the file was modified on Dropbox.
@property (nonatomic, readonly) NSDate *serverModified;

/// The member id of the revision's author.
@property (nonatomic, readonly, copy) NSString *authorMemberId;

/// The member status of the revision's author.
@property (nonatomic, readonly) DBTEAMTeamMemberStatus *authorMemberStatus;

/// The email address of the held revision author.
@property (nonatomic, readonly, copy) NSString *authorEmail;

/// The type of the held revision's file.
@property (nonatomic, readonly, copy) NSString *fileType;

/// The file size in bytes.
@property (nonatomic, readonly) NSNumber *size;

/// A hash of the file content. This field can be used to verify data integrity.
/// For more information see our Content hash
/// https://www.dropbox.com/developers/reference/content-hash page.
@property (nonatomic, readonly, copy) NSString *contentHash;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewFilename The held revision filename.
/// @param originalRevisionId The id of the held revision.
/// @param originalFilePath The original path of the held revision.
/// @param serverModified The last time the file was modified on Dropbox.
/// @param authorMemberId The member id of the revision's author.
/// @param authorMemberStatus The member status of the revision's author.
/// @param authorEmail The email address of the held revision author.
/// @param fileType The type of the held revision's file.
/// @param size The file size in bytes.
/// @param contentHash A hash of the file content. This field can be used to
/// verify data integrity. For more information see our Content hash
/// https://www.dropbox.com/developers/reference/content-hash page.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewFilename:(NSString *)dNewFilename
                  originalRevisionId:(NSString *)originalRevisionId
                    originalFilePath:(NSString *)originalFilePath
                      serverModified:(NSDate *)serverModified
                      authorMemberId:(NSString *)authorMemberId
                  authorMemberStatus:(DBTEAMTeamMemberStatus *)authorMemberStatus
                         authorEmail:(NSString *)authorEmail
                            fileType:(NSString *)fileType
                                size:(NSNumber *)size
                         contentHash:(NSString *)contentHash;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `LegalHoldHeldRevisionMetadata` struct.
///
@interface DBTEAMLegalHoldHeldRevisionMetadataSerializer : NSObject

///
/// Serializes `DBTEAMLegalHoldHeldRevisionMetadata` instances.
///
/// @param instance An instance of the `DBTEAMLegalHoldHeldRevisionMetadata` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldHeldRevisionMetadata` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldHeldRevisionMetadata *)instance;

///
/// Deserializes `DBTEAMLegalHoldHeldRevisionMetadata` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldHeldRevisionMetadata` API object.
///
/// @return An instantiation of the `DBTEAMLegalHoldHeldRevisionMetadata`
/// object.
///
+ (DBTEAMLegalHoldHeldRevisionMetadata *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
