///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPaperMemberPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperMemberPolicy` union.
///
/// Policy for controlling if team members can share Paper documents externally.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPaperMemberPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGPaperMemberPolicyTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGPaperMemberPolicy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGPaperMemberPolicyTag){
    /// (no description).
    DBTEAMLOGPaperMemberPolicyAnyoneWithLink,

    /// (no description).
    DBTEAMLOGPaperMemberPolicyOnlyTeam,

    /// (no description).
    DBTEAMLOGPaperMemberPolicyTeamAndExplicitlyShared,

    /// (no description).
    DBTEAMLOGPaperMemberPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGPaperMemberPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "anyone_with_link".
///
/// @return An initialized instance.
///
- (instancetype)initWithAnyoneWithLink;

///
/// Initializes union class with tag state of "only_team".
///
/// @return An initialized instance.
///
- (instancetype)initWithOnlyTeam;

///
/// Initializes union class with tag state of "team_and_explicitly_shared".
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamAndExplicitlyShared;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "anyone_with_link".
///
/// @return Whether the union's current tag state has value "anyone_with_link".
///
- (BOOL)isAnyoneWithLink;

///
/// Retrieves whether the union's current tag state has value "only_team".
///
/// @return Whether the union's current tag state has value "only_team".
///
- (BOOL)isOnlyTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_and_explicitly_shared".
///
/// @return Whether the union's current tag state has value
/// "team_and_explicitly_shared".
///
- (BOOL)isTeamAndExplicitlyShared;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGPaperMemberPolicy` union.
///
@interface DBTEAMLOGPaperMemberPolicySerializer : NSObject

///
/// Serializes `DBTEAMLOGPaperMemberPolicy` instances.
///
/// @param instance An instance of the `DBTEAMLOGPaperMemberPolicy` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperMemberPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPaperMemberPolicy *)instance;

///
/// Deserializes `DBTEAMLOGPaperMemberPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperMemberPolicy` API object.
///
/// @return An instantiation of the `DBTEAMLOGPaperMemberPolicy` object.
///
+ (DBTEAMLOGPaperMemberPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
