///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGLabelType;
@class DBTEAMLOGObjectLabelRemovedDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ObjectLabelRemovedDetails` struct.
///
/// Removed a label.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGObjectLabelRemovedDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Labels mark a file or folder.
@property (nonatomic, readonly) DBTEAMLOGLabelType *labelType;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param labelType Labels mark a file or folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithLabelType:(DBTEAMLOGLabelType *)labelType;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ObjectLabelRemovedDetails` struct.
///
@interface DBTEAMLOGObjectLabelRemovedDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGObjectLabelRemovedDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGObjectLabelRemovedDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGObjectLabelRemovedDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGObjectLabelRemovedDetails *)instance;

///
/// Deserializes `DBTEAMLOGObjectLabelRemovedDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGObjectLabelRemovedDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGObjectLabelRemovedDetails` object.
///
+ (DBTEAMLOGObjectLabelRemovedDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
