///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGMissingDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MissingDetails` struct.
///
/// An indication that an error occurred while retrieving the event. Some
/// attributes of the event may be omitted as a result.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGMissingDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// All the data that could be retrieved and converted from the source event.
@property (nonatomic, readonly, copy, nullable) NSString *sourceEventFields;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sourceEventFields All the data that could be retrieved and converted
/// from the source event.
///
/// @return An initialized instance.
///
- (instancetype)initWithSourceEventFields:(nullable NSString *)sourceEventFields;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MissingDetails` struct.
///
@interface DBTEAMLOGMissingDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGMissingDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGMissingDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGMissingDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGMissingDetails *)instance;

///
/// Deserializes `DBTEAMLOGMissingDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGMissingDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGMissingDetails` object.
///
+ (DBTEAMLOGMissingDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
