///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGMemberChangeNameDetails;
@class DBTEAMLOGUserNameLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberChangeNameDetails` struct.
///
/// Changed team member name.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGMemberChangeNameDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New user's name.
@property (nonatomic, readonly) DBTEAMLOGUserNameLogInfo *dNewValue;

/// Previous user's name. Might be missing due to historical data gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGUserNameLogInfo *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New user's name.
/// @param previousValue Previous user's name. Might be missing due to
/// historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMLOGUserNameLogInfo *)dNewValue
                    previousValue:(nullable DBTEAMLOGUserNameLogInfo *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param dNewValue New user's name.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMLOGUserNameLogInfo *)dNewValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MemberChangeNameDetails` struct.
///
@interface DBTEAMLOGMemberChangeNameDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGMemberChangeNameDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGMemberChangeNameDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGMemberChangeNameDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGMemberChangeNameDetails *)instance;

///
/// Deserializes `DBTEAMLOGMemberChangeNameDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGMemberChangeNameDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGMemberChangeNameDetails` object.
///
+ (DBTEAMLOGMemberChangeNameDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
