///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGLegalHoldsChangeHoldDetailsDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldsChangeHoldDetailsDetails` struct.
///
/// Edited details for a hold.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGLegalHoldsChangeHoldDetailsDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Hold ID.
@property (nonatomic, readonly, copy) NSString *legalHoldId;

/// Hold name.
@property (nonatomic, readonly, copy) NSString *name;

/// Previous details.
@property (nonatomic, readonly, copy) NSString *previousValue;

/// New details.
@property (nonatomic, readonly, copy) NSString *dNewValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param legalHoldId Hold ID.
/// @param name Hold name.
/// @param previousValue Previous details.
/// @param dNewValue New details.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldId:(NSString *)legalHoldId
                               name:(NSString *)name
                      previousValue:(NSString *)previousValue
                          dNewValue:(NSString *)dNewValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `LegalHoldsChangeHoldDetailsDetails` struct.
///
@interface DBTEAMLOGLegalHoldsChangeHoldDetailsDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGLegalHoldsChangeHoldDetailsDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGLegalHoldsChangeHoldDetailsDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGLegalHoldsChangeHoldDetailsDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGLegalHoldsChangeHoldDetailsDetails *)instance;

///
/// Deserializes `DBTEAMLOGLegalHoldsChangeHoldDetailsDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGLegalHoldsChangeHoldDetailsDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGLegalHoldsChangeHoldDetailsDetails` object.
///
+ (DBTEAMLOGLegalHoldsChangeHoldDetailsDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
