///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGGovernancePolicyRemoveFoldersDetails;
@class DBTEAMLOGPolicyType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GovernancePolicyRemoveFoldersDetails` struct.
///
/// Removed folders from policy.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGovernancePolicyRemoveFoldersDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Policy ID.
@property (nonatomic, readonly, copy) NSString *governancePolicyId;

/// Policy name.
@property (nonatomic, readonly, copy) NSString *name;

/// Policy type.
@property (nonatomic, readonly, nullable) DBTEAMLOGPolicyType *policyType;

/// Folders.
@property (nonatomic, readonly, nullable) NSArray<NSString *> *folders;

/// Reason.
@property (nonatomic, readonly, copy, nullable) NSString *reason;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param policyType Policy type.
/// @param folders Folders.
/// @param reason Reason.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                                policyType:(nullable DBTEAMLOGPolicyType *)policyType
                                   folders:(nullable NSArray<NSString *> *)folders
                                    reason:(nullable NSString *)reason;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId name:(NSString *)name;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GovernancePolicyRemoveFoldersDetails`
/// struct.
///
@interface DBTEAMLOGGovernancePolicyRemoveFoldersDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGGovernancePolicyRemoveFoldersDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGGovernancePolicyRemoveFoldersDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyRemoveFoldersDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGovernancePolicyRemoveFoldersDetails *)instance;

///
/// Deserializes `DBTEAMLOGGovernancePolicyRemoveFoldersDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyRemoveFoldersDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGGovernancePolicyRemoveFoldersDetails` object.
///
+ (DBTEAMLOGGovernancePolicyRemoveFoldersDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
