///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGExternalUserLogInfo;
@class DBTEAMLOGIdentifierType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ExternalUserLogInfo` struct.
///
/// A user without a Dropbox account.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGExternalUserLogInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// An external user identifier.
@property (nonatomic, readonly, copy) NSString *userIdentifier;

/// Identifier type.
@property (nonatomic, readonly) DBTEAMLOGIdentifierType *identifierType;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param userIdentifier An external user identifier.
/// @param identifierType Identifier type.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserIdentifier:(NSString *)userIdentifier
                        identifierType:(DBTEAMLOGIdentifierType *)identifierType;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ExternalUserLogInfo` struct.
///
@interface DBTEAMLOGExternalUserLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGExternalUserLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGExternalUserLogInfo` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGExternalUserLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGExternalUserLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGExternalUserLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGExternalUserLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGExternalUserLogInfo` object.
///
+ (DBTEAMLOGExternalUserLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
