///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGExtendedVersionHistoryPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ExtendedVersionHistoryPolicy` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGExtendedVersionHistoryPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGExtendedVersionHistoryPolicyTag` enum type represents the
/// possible tag states with which the `DBTEAMLOGExtendedVersionHistoryPolicy`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGExtendedVersionHistoryPolicyTag){
    /// (no description).
    DBTEAMLOGExtendedVersionHistoryPolicyExplicitlyLimited,

    /// (no description).
    DBTEAMLOGExtendedVersionHistoryPolicyExplicitlyUnlimited,

    /// (no description).
    DBTEAMLOGExtendedVersionHistoryPolicyImplicitlyLimited,

    /// (no description).
    DBTEAMLOGExtendedVersionHistoryPolicyImplicitlyUnlimited,

    /// (no description).
    DBTEAMLOGExtendedVersionHistoryPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGExtendedVersionHistoryPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "explicitly_limited".
///
/// @return An initialized instance.
///
- (instancetype)initWithExplicitlyLimited;

///
/// Initializes union class with tag state of "explicitly_unlimited".
///
/// @return An initialized instance.
///
- (instancetype)initWithExplicitlyUnlimited;

///
/// Initializes union class with tag state of "implicitly_limited".
///
/// @return An initialized instance.
///
- (instancetype)initWithImplicitlyLimited;

///
/// Initializes union class with tag state of "implicitly_unlimited".
///
/// @return An initialized instance.
///
- (instancetype)initWithImplicitlyUnlimited;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "explicitly_limited".
///
/// @return Whether the union's current tag state has value
/// "explicitly_limited".
///
- (BOOL)isExplicitlyLimited;

///
/// Retrieves whether the union's current tag state has value
/// "explicitly_unlimited".
///
/// @return Whether the union's current tag state has value
/// "explicitly_unlimited".
///
- (BOOL)isExplicitlyUnlimited;

///
/// Retrieves whether the union's current tag state has value
/// "implicitly_limited".
///
/// @return Whether the union's current tag state has value
/// "implicitly_limited".
///
- (BOOL)isImplicitlyLimited;

///
/// Retrieves whether the union's current tag state has value
/// "implicitly_unlimited".
///
/// @return Whether the union's current tag state has value
/// "implicitly_unlimited".
///
- (BOOL)isImplicitlyUnlimited;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGExtendedVersionHistoryPolicy`
/// union.
///
@interface DBTEAMLOGExtendedVersionHistoryPolicySerializer : NSObject

///
/// Serializes `DBTEAMLOGExtendedVersionHistoryPolicy` instances.
///
/// @param instance An instance of the `DBTEAMLOGExtendedVersionHistoryPolicy`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGExtendedVersionHistoryPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGExtendedVersionHistoryPolicy *)instance;

///
/// Deserializes `DBTEAMLOGExtendedVersionHistoryPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGExtendedVersionHistoryPolicy` API object.
///
/// @return An instantiation of the `DBTEAMLOGExtendedVersionHistoryPolicy`
/// object.
///
+ (DBTEAMLOGExtendedVersionHistoryPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
