///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDeviceApprovalsPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeviceApprovalsPolicy` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDeviceApprovalsPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGDeviceApprovalsPolicyTag` enum type represents the possible
/// tag states with which the `DBTEAMLOGDeviceApprovalsPolicy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGDeviceApprovalsPolicyTag){
    /// (no description).
    DBTEAMLOGDeviceApprovalsPolicyLimited,

    /// (no description).
    DBTEAMLOGDeviceApprovalsPolicyUnlimited,

    /// (no description).
    DBTEAMLOGDeviceApprovalsPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGDeviceApprovalsPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "limited".
///
/// @return An initialized instance.
///
- (instancetype)initWithLimited;

///
/// Initializes union class with tag state of "unlimited".
///
/// @return An initialized instance.
///
- (instancetype)initWithUnlimited;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "limited".
///
/// @return Whether the union's current tag state has value "limited".
///
- (BOOL)isLimited;

///
/// Retrieves whether the union's current tag state has value "unlimited".
///
/// @return Whether the union's current tag state has value "unlimited".
///
- (BOOL)isUnlimited;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGDeviceApprovalsPolicy` union.
///
@interface DBTEAMLOGDeviceApprovalsPolicySerializer : NSObject

///
/// Serializes `DBTEAMLOGDeviceApprovalsPolicy` instances.
///
/// @param instance An instance of the `DBTEAMLOGDeviceApprovalsPolicy` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceApprovalsPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsPolicy *)instance;

///
/// Deserializes `DBTEAMLOGDeviceApprovalsPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceApprovalsPolicy` API object.
///
/// @return An instantiation of the `DBTEAMLOGDeviceApprovalsPolicy` object.
///
+ (DBTEAMLOGDeviceApprovalsPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
