///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGBinderRenamePageDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `BinderRenamePageDetails` struct.
///
/// Renamed Binder page.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGBinderRenamePageDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Event unique identifier.
@property (nonatomic, readonly, copy) NSString *eventUuid;

/// Title of the Binder doc.
@property (nonatomic, readonly, copy) NSString *docTitle;

/// Name of the Binder page/section.
@property (nonatomic, readonly, copy) NSString *binderItemName;

/// Previous name of the Binder page/section.
@property (nonatomic, readonly, copy, nullable) NSString *previousBinderItemName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param eventUuid Event unique identifier.
/// @param docTitle Title of the Binder doc.
/// @param binderItemName Name of the Binder page/section.
/// @param previousBinderItemName Previous name of the Binder page/section.
///
/// @return An initialized instance.
///
- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName
           previousBinderItemName:(nullable NSString *)previousBinderItemName;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param eventUuid Event unique identifier.
/// @param docTitle Title of the Binder doc.
/// @param binderItemName Name of the Binder page/section.
///
/// @return An initialized instance.
///
- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `BinderRenamePageDetails` struct.
///
@interface DBTEAMLOGBinderRenamePageDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGBinderRenamePageDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGBinderRenamePageDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGBinderRenamePageDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRenamePageDetails *)instance;

///
/// Deserializes `DBTEAMLOGBinderRenamePageDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGBinderRenamePageDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGBinderRenamePageDetails` object.
///
+ (DBTEAMLOGBinderRenamePageDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
