///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAdminRole;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AdminRole` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAdminRole : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGAdminRoleTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGAdminRole` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGAdminRoleTag){
    /// (no description).
    DBTEAMLOGAdminRoleBillingAdmin,

    /// (no description).
    DBTEAMLOGAdminRoleLimitedAdmin,

    /// (no description).
    DBTEAMLOGAdminRoleMemberOnly,

    /// (no description).
    DBTEAMLOGAdminRoleSupportAdmin,

    /// (no description).
    DBTEAMLOGAdminRoleTeamAdmin,

    /// (no description).
    DBTEAMLOGAdminRoleUserManagementAdmin,

    /// (no description).
    DBTEAMLOGAdminRoleOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGAdminRoleTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "billing_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithBillingAdmin;

///
/// Initializes union class with tag state of "limited_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithLimitedAdmin;

///
/// Initializes union class with tag state of "member_only".
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberOnly;

///
/// Initializes union class with tag state of "support_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithSupportAdmin;

///
/// Initializes union class with tag state of "team_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamAdmin;

///
/// Initializes union class with tag state of "user_management_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithUserManagementAdmin;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "billing_admin".
///
/// @return Whether the union's current tag state has value "billing_admin".
///
- (BOOL)isBillingAdmin;

///
/// Retrieves whether the union's current tag state has value "limited_admin".
///
/// @return Whether the union's current tag state has value "limited_admin".
///
- (BOOL)isLimitedAdmin;

///
/// Retrieves whether the union's current tag state has value "member_only".
///
/// @return Whether the union's current tag state has value "member_only".
///
- (BOOL)isMemberOnly;

///
/// Retrieves whether the union's current tag state has value "support_admin".
///
/// @return Whether the union's current tag state has value "support_admin".
///
- (BOOL)isSupportAdmin;

///
/// Retrieves whether the union's current tag state has value "team_admin".
///
/// @return Whether the union's current tag state has value "team_admin".
///
- (BOOL)isTeamAdmin;

///
/// Retrieves whether the union's current tag state has value
/// "user_management_admin".
///
/// @return Whether the union's current tag state has value
/// "user_management_admin".
///
- (BOOL)isUserManagementAdmin;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGAdminRole` union.
///
@interface DBTEAMLOGAdminRoleSerializer : NSObject

///
/// Serializes `DBTEAMLOGAdminRole` instances.
///
/// @param instance An instance of the `DBTEAMLOGAdminRole` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminRole` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminRole *)instance;

///
/// Deserializes `DBTEAMLOGAdminRole` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminRole` API object.
///
/// @return An instantiation of the `DBTEAMLOGAdminRole` object.
///
+ (DBTEAMLOGAdminRole *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
