///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAdminAlertingAlertStatePolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AdminAlertingAlertStatePolicy` union.
///
/// Policy for controlling whether an alert can be triggered or not
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAdminAlertingAlertStatePolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGAdminAlertingAlertStatePolicyTag` enum type represents the
/// possible tag states with which the `DBTEAMLOGAdminAlertingAlertStatePolicy`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGAdminAlertingAlertStatePolicyTag){
    /// (no description).
    DBTEAMLOGAdminAlertingAlertStatePolicyOff,

    /// (no description).
    DBTEAMLOGAdminAlertingAlertStatePolicyOn,

    /// (no description).
    DBTEAMLOGAdminAlertingAlertStatePolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGAdminAlertingAlertStatePolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "off".
///
/// @return An initialized instance.
///
- (instancetype)initWithOff;

///
/// Initializes union class with tag state of "on".
///
/// @return An initialized instance.
///
- (instancetype)initWithOn;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "off".
///
/// @return Whether the union's current tag state has value "off".
///
- (BOOL)isOff;

///
/// Retrieves whether the union's current tag state has value "on".
///
/// @return Whether the union's current tag state has value "on".
///
- (BOOL)isOn;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGAdminAlertingAlertStatePolicy`
/// union.
///
@interface DBTEAMLOGAdminAlertingAlertStatePolicySerializer : NSObject

///
/// Serializes `DBTEAMLOGAdminAlertingAlertStatePolicy` instances.
///
/// @param instance An instance of the `DBTEAMLOGAdminAlertingAlertStatePolicy`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingAlertStatePolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingAlertStatePolicy *)instance;

///
/// Deserializes `DBTEAMLOGAdminAlertingAlertStatePolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingAlertStatePolicy` API object.
///
/// @return An instantiation of the `DBTEAMLOGAdminAlertingAlertStatePolicy`
/// object.
///
+ (DBTEAMLOGAdminAlertingAlertStatePolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
