///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAdminAlertSeverityEnum;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AdminAlertSeverityEnum` union.
///
/// Alert severity
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAdminAlertSeverityEnum : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGAdminAlertSeverityEnumTag` enum type represents the possible
/// tag states with which the `DBTEAMLOGAdminAlertSeverityEnum` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGAdminAlertSeverityEnumTag){
    /// (no description).
    DBTEAMLOGAdminAlertSeverityEnumHigh,

    /// (no description).
    DBTEAMLOGAdminAlertSeverityEnumInfo,

    /// (no description).
    DBTEAMLOGAdminAlertSeverityEnumLow,

    /// (no description).
    DBTEAMLOGAdminAlertSeverityEnumMedium,

    /// (no description).
    DBTEAMLOGAdminAlertSeverityEnumNa,

    /// (no description).
    DBTEAMLOGAdminAlertSeverityEnumOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGAdminAlertSeverityEnumTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "high".
///
/// @return An initialized instance.
///
- (instancetype)initWithHigh;

///
/// Initializes union class with tag state of "info".
///
/// @return An initialized instance.
///
- (instancetype)initWithInfo;

///
/// Initializes union class with tag state of "low".
///
/// @return An initialized instance.
///
- (instancetype)initWithLow;

///
/// Initializes union class with tag state of "medium".
///
/// @return An initialized instance.
///
- (instancetype)initWithMedium;

///
/// Initializes union class with tag state of "na".
///
/// @return An initialized instance.
///
- (instancetype)initWithNa;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "high".
///
/// @return Whether the union's current tag state has value "high".
///
- (BOOL)isHigh;

///
/// Retrieves whether the union's current tag state has value "info".
///
/// @return Whether the union's current tag state has value "info".
///
- (BOOL)isInfo;

///
/// Retrieves whether the union's current tag state has value "low".
///
/// @return Whether the union's current tag state has value "low".
///
- (BOOL)isLow;

///
/// Retrieves whether the union's current tag state has value "medium".
///
/// @return Whether the union's current tag state has value "medium".
///
- (BOOL)isMedium;

///
/// Retrieves whether the union's current tag state has value "na".
///
/// @return Whether the union's current tag state has value "na".
///
- (BOOL)isNa;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGAdminAlertSeverityEnum` union.
///
@interface DBTEAMLOGAdminAlertSeverityEnumSerializer : NSObject

///
/// Serializes `DBTEAMLOGAdminAlertSeverityEnum` instances.
///
/// @param instance An instance of the `DBTEAMLOGAdminAlertSeverityEnum` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertSeverityEnum` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertSeverityEnum *)instance;

///
/// Deserializes `DBTEAMLOGAdminAlertSeverityEnum` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertSeverityEnum` API object.
///
/// @return An instantiation of the `DBTEAMLOGAdminAlertSeverityEnum` object.
///
+ (DBTEAMLOGAdminAlertSeverityEnum *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
