///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAccessMethodLogInfo;
@class DBTEAMLOGApiSessionLogInfo;
@class DBTEAMLOGSessionLogInfo;
@class DBTEAMLOGWebSessionLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AccessMethodLogInfo` union.
///
/// Indicates the method in which the action was performed.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAccessMethodLogInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGAccessMethodLogInfoTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGAccessMethodLogInfo` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGAccessMethodLogInfoTag){
    /// Admin console session details.
    DBTEAMLOGAccessMethodLogInfoAdminConsole,

    /// Api session details.
    DBTEAMLOGAccessMethodLogInfoApi,

    /// Content manager session details.
    DBTEAMLOGAccessMethodLogInfoContentManager,

    /// End user session details.
    DBTEAMLOGAccessMethodLogInfoEndUser,

    /// Enterprise console session details.
    DBTEAMLOGAccessMethodLogInfoEnterpriseConsole,

    /// Sign in as session details.
    DBTEAMLOGAccessMethodLogInfoSignInAs,

    /// (no description).
    DBTEAMLOGAccessMethodLogInfoOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGAccessMethodLogInfoTag tag;

/// Admin console session details. @note Ensure the `isAdminConsole` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGWebSessionLogInfo *adminConsole;

/// Api session details. @note Ensure the `isApi` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGApiSessionLogInfo *api;

/// Content manager session details. @note Ensure the `isContentManager` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGWebSessionLogInfo *contentManager;

/// End user session details. @note Ensure the `isEndUser` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGSessionLogInfo *endUser;

/// Enterprise console session details. @note Ensure the `isEnterpriseConsole`
/// method returns true before accessing, otherwise a runtime exception will be
/// raised.
@property (nonatomic, readonly) DBTEAMLOGWebSessionLogInfo *enterpriseConsole;

/// Sign in as session details. @note Ensure the `isSignInAs` method returns
/// true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGWebSessionLogInfo *signInAs;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "admin_console".
///
/// Description of the "admin_console" tag state: Admin console session details.
///
/// @param adminConsole Admin console session details.
///
/// @return An initialized instance.
///
- (instancetype)initWithAdminConsole:(DBTEAMLOGWebSessionLogInfo *)adminConsole;

///
/// Initializes union class with tag state of "api".
///
/// Description of the "api" tag state: Api session details.
///
/// @param api Api session details.
///
/// @return An initialized instance.
///
- (instancetype)initWithApi:(DBTEAMLOGApiSessionLogInfo *)api;

///
/// Initializes union class with tag state of "content_manager".
///
/// Description of the "content_manager" tag state: Content manager session
/// details.
///
/// @param contentManager Content manager session details.
///
/// @return An initialized instance.
///
- (instancetype)initWithContentManager:(DBTEAMLOGWebSessionLogInfo *)contentManager;

///
/// Initializes union class with tag state of "end_user".
///
/// Description of the "end_user" tag state: End user session details.
///
/// @param endUser End user session details.
///
/// @return An initialized instance.
///
- (instancetype)initWithEndUser:(DBTEAMLOGSessionLogInfo *)endUser;

///
/// Initializes union class with tag state of "enterprise_console".
///
/// Description of the "enterprise_console" tag state: Enterprise console
/// session details.
///
/// @param enterpriseConsole Enterprise console session details.
///
/// @return An initialized instance.
///
- (instancetype)initWithEnterpriseConsole:(DBTEAMLOGWebSessionLogInfo *)enterpriseConsole;

///
/// Initializes union class with tag state of "sign_in_as".
///
/// Description of the "sign_in_as" tag state: Sign in as session details.
///
/// @param signInAs Sign in as session details.
///
/// @return An initialized instance.
///
- (instancetype)initWithSignInAs:(DBTEAMLOGWebSessionLogInfo *)signInAs;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "admin_console".
///
/// @note Call this method and ensure it returns true before accessing the
/// `adminConsole` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "admin_console".
///
- (BOOL)isAdminConsole;

///
/// Retrieves whether the union's current tag state has value "api".
///
/// @note Call this method and ensure it returns true before accessing the `api`
/// property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "api".
///
- (BOOL)isApi;

///
/// Retrieves whether the union's current tag state has value "content_manager".
///
/// @note Call this method and ensure it returns true before accessing the
/// `contentManager` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "content_manager".
///
- (BOOL)isContentManager;

///
/// Retrieves whether the union's current tag state has value "end_user".
///
/// @note Call this method and ensure it returns true before accessing the
/// `endUser` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "end_user".
///
- (BOOL)isEndUser;

///
/// Retrieves whether the union's current tag state has value
/// "enterprise_console".
///
/// @note Call this method and ensure it returns true before accessing the
/// `enterpriseConsole` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "enterprise_console".
///
- (BOOL)isEnterpriseConsole;

///
/// Retrieves whether the union's current tag state has value "sign_in_as".
///
/// @note Call this method and ensure it returns true before accessing the
/// `signInAs` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "sign_in_as".
///
- (BOOL)isSignInAs;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGAccessMethodLogInfo` union.
///
@interface DBTEAMLOGAccessMethodLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGAccessMethodLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGAccessMethodLogInfo` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAccessMethodLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccessMethodLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGAccessMethodLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAccessMethodLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGAccessMethodLogInfo` object.
///
+ (DBTEAMLOGAccessMethodLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
