///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMGroupsPollError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GroupsPollError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMGroupsPollError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMGroupsPollErrorTag` enum type represents the possible tag states
/// with which the `DBTEAMGroupsPollError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMGroupsPollErrorTag){
    /// The job ID is invalid.
    DBTEAMGroupsPollErrorInvalidAsyncJobId,

    /// Something went wrong with the job on Dropbox's end. You'll need to
    /// verify that the action you were taking succeeded, and if not, try again.
    /// This should happen very rarely.
    DBTEAMGroupsPollErrorInternalError,

    /// (no description).
    DBTEAMGroupsPollErrorOther,

    /// You are not allowed to poll this job.
    DBTEAMGroupsPollErrorAccessDenied,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMGroupsPollErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "invalid_async_job_id".
///
/// Description of the "invalid_async_job_id" tag state: The job ID is invalid.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidAsyncJobId;

///
/// Initializes union class with tag state of "internal_error".
///
/// Description of the "internal_error" tag state: Something went wrong with the
/// job on Dropbox's end. You'll need to verify that the action you were taking
/// succeeded, and if not, try again. This should happen very rarely.
///
/// @return An initialized instance.
///
- (instancetype)initWithInternalError;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of "access_denied".
///
/// Description of the "access_denied" tag state: You are not allowed to poll
/// this job.
///
/// @return An initialized instance.
///
- (instancetype)initWithAccessDenied;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "invalid_async_job_id".
///
/// @return Whether the union's current tag state has value
/// "invalid_async_job_id".
///
- (BOOL)isInvalidAsyncJobId;

///
/// Retrieves whether the union's current tag state has value "internal_error".
///
/// @return Whether the union's current tag state has value "internal_error".
///
- (BOOL)isInternalError;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value "access_denied".
///
/// @return Whether the union's current tag state has value "access_denied".
///
- (BOOL)isAccessDenied;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMGroupsPollError` union.
///
@interface DBTEAMGroupsPollErrorSerializer : NSObject

///
/// Serializes `DBTEAMGroupsPollError` instances.
///
/// @param instance An instance of the `DBTEAMGroupsPollError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMGroupsPollError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsPollError *)instance;

///
/// Deserializes `DBTEAMGroupsPollError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMGroupsPollError` API object.
///
/// @return An instantiation of the `DBTEAMGroupsPollError` object.
///
+ (DBTEAMGroupsPollError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
