///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMCOMMONGroupSummary;
@class DBTEAMGroupsListResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GroupsListResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMGroupsListResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// (no description).
@property (nonatomic, readonly) NSArray<DBTEAMCOMMONGroupSummary *> *groups;

/// Pass the cursor into `groupsListContinue` to obtain the additional groups.
@property (nonatomic, readonly, copy) NSString *cursor;

/// Is true if there are additional groups that have not been returned yet. An
/// additional call to `groupsListContinue` can retrieve them.
@property (nonatomic, readonly) NSNumber *hasMore;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param groups (no description).
/// @param cursor Pass the cursor into `groupsListContinue` to obtain the
/// additional groups.
/// @param hasMore Is true if there are additional groups that have not been
/// returned yet. An additional call to `groupsListContinue` can retrieve them.
///
/// @return An initialized instance.
///
- (instancetype)initWithGroups:(NSArray<DBTEAMCOMMONGroupSummary *> *)groups
                        cursor:(NSString *)cursor
                       hasMore:(NSNumber *)hasMore;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GroupsListResult` struct.
///
@interface DBTEAMGroupsListResultSerializer : NSObject

///
/// Serializes `DBTEAMGroupsListResult` instances.
///
/// @param instance An instance of the `DBTEAMGroupsListResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMGroupsListResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsListResult *)instance;

///
/// Deserializes `DBTEAMGroupsListResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMGroupsListResult` API object.
///
/// @return An instantiation of the `DBTEAMGroupsListResult` object.
///
+ (DBTEAMGroupsListResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
