///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMGroupMembersSelector;
@class DBTEAMGroupSelector;
@class DBTEAMUsersSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GroupMembersSelector` struct.
///
/// Argument for selecting a group and a list of users.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMGroupMembersSelector : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Specify a group.
@property (nonatomic, readonly) DBTEAMGroupSelector *group;

/// A list of users that are members of group.
@property (nonatomic, readonly) DBTEAMUsersSelectorArg *users;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param group Specify a group.
/// @param users A list of users that are members of group.
///
/// @return An initialized instance.
///
- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group users:(DBTEAMUsersSelectorArg *)users;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GroupMembersSelector` struct.
///
@interface DBTEAMGroupMembersSelectorSerializer : NSObject

///
/// Serializes `DBTEAMGroupMembersSelector` instances.
///
/// @param instance An instance of the `DBTEAMGroupMembersSelector` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMGroupMembersSelector` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersSelector *)instance;

///
/// Deserializes `DBTEAMGroupMembersSelector` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMGroupMembersSelector` API object.
///
/// @return An instantiation of the `DBTEAMGroupMembersSelector` object.
///
+ (DBTEAMGroupMembersSelector *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
