///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMExcludedUsersUpdateStatus;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ExcludedUsersUpdateStatus` union.
///
/// Excluded users update operation status.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMExcludedUsersUpdateStatus : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMExcludedUsersUpdateStatusTag` enum type represents the possible
/// tag states with which the `DBTEAMExcludedUsersUpdateStatus` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMExcludedUsersUpdateStatusTag){
    /// Update successful.
    DBTEAMExcludedUsersUpdateStatusSuccess,

    /// (no description).
    DBTEAMExcludedUsersUpdateStatusOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMExcludedUsersUpdateStatusTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "success".
///
/// Description of the "success" tag state: Update successful.
///
/// @return An initialized instance.
///
- (instancetype)initWithSuccess;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "success".
///
/// @return Whether the union's current tag state has value "success".
///
- (BOOL)isSuccess;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMExcludedUsersUpdateStatus` union.
///
@interface DBTEAMExcludedUsersUpdateStatusSerializer : NSObject

///
/// Serializes `DBTEAMExcludedUsersUpdateStatus` instances.
///
/// @param instance An instance of the `DBTEAMExcludedUsersUpdateStatus` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMExcludedUsersUpdateStatus` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersUpdateStatus *)instance;

///
/// Deserializes `DBTEAMExcludedUsersUpdateStatus` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMExcludedUsersUpdateStatus` API object.
///
/// @return An instantiation of the `DBTEAMExcludedUsersUpdateStatus` object.
///
+ (DBTEAMExcludedUsersUpdateStatus *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
