///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMExcludedUsersUpdateArg;
@class DBTEAMUserSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ExcludedUsersUpdateArg` struct.
///
/// Argument of excluded users update operation. Should include a list of users
/// to add/remove (according to endpoint), Maximum size of the list is 1000
/// users.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMExcludedUsersUpdateArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// List of users to be added/removed.
@property (nonatomic, readonly, nullable) NSArray<DBTEAMUserSelectorArg *> *users;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param users List of users to be added/removed.
///
/// @return An initialized instance.
///
- (instancetype)initWithUsers:(nullable NSArray<DBTEAMUserSelectorArg *> *)users;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ExcludedUsersUpdateArg` struct.
///
@interface DBTEAMExcludedUsersUpdateArgSerializer : NSObject

///
/// Serializes `DBTEAMExcludedUsersUpdateArg` instances.
///
/// @param instance An instance of the `DBTEAMExcludedUsersUpdateArg` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMExcludedUsersUpdateArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersUpdateArg *)instance;

///
/// Deserializes `DBTEAMExcludedUsersUpdateArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMExcludedUsersUpdateArg` API object.
///
/// @return An instantiation of the `DBTEAMExcludedUsersUpdateArg` object.
///
+ (DBTEAMExcludedUsersUpdateArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
