///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMAddSecondaryEmailsError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AddSecondaryEmailsError` union.
///
/// Error returned when adding secondary emails fails.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMAddSecondaryEmailsError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMAddSecondaryEmailsErrorTag` enum type represents the possible tag
/// states with which the `DBTEAMAddSecondaryEmailsError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMAddSecondaryEmailsErrorTag){
    /// Secondary emails are disabled for the team.
    DBTEAMAddSecondaryEmailsErrorSecondaryEmailsDisabled,

    /// A maximum of 20 secondary emails can be added in a single call.
    DBTEAMAddSecondaryEmailsErrorTooManyEmails,

    /// (no description).
    DBTEAMAddSecondaryEmailsErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMAddSecondaryEmailsErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "secondary_emails_disabled".
///
/// Description of the "secondary_emails_disabled" tag state: Secondary emails
/// are disabled for the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithSecondaryEmailsDisabled;

///
/// Initializes union class with tag state of "too_many_emails".
///
/// Description of the "too_many_emails" tag state: A maximum of 20 secondary
/// emails can be added in a single call.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyEmails;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "secondary_emails_disabled".
///
/// @return Whether the union's current tag state has value
/// "secondary_emails_disabled".
///
- (BOOL)isSecondaryEmailsDisabled;

///
/// Retrieves whether the union's current tag state has value "too_many_emails".
///
/// @return Whether the union's current tag state has value "too_many_emails".
///
- (BOOL)isTooManyEmails;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMAddSecondaryEmailsError` union.
///
@interface DBTEAMAddSecondaryEmailsErrorSerializer : NSObject

///
/// Serializes `DBTEAMAddSecondaryEmailsError` instances.
///
/// @param instance An instance of the `DBTEAMAddSecondaryEmailsError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMAddSecondaryEmailsError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMAddSecondaryEmailsError *)instance;

///
/// Deserializes `DBTEAMAddSecondaryEmailsError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMAddSecondaryEmailsError` API object.
///
/// @return An instantiation of the `DBTEAMAddSecondaryEmailsError` object.
///
+ (DBTEAMAddSecondaryEmailsError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
