///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGRequestedLinkAccessLevel;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `RequestedLinkAccessLevel` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGRequestedLinkAccessLevel : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGRequestedLinkAccessLevelTag` enum type represents the possible
/// tag states with which the `DBSHARINGRequestedLinkAccessLevel` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGRequestedLinkAccessLevelTag){
    /// Users who use the link can view and comment on the content.
    DBSHARINGRequestedLinkAccessLevelViewer,

    /// Users who use the link can edit, view and comment on the content. Note
    /// not all file types support edit links yet.
    DBSHARINGRequestedLinkAccessLevelEditor,

    /// Request for the maximum access level you can set the link to.
    DBSHARINGRequestedLinkAccessLevelMax,

    /// (no description).
    DBSHARINGRequestedLinkAccessLevelOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGRequestedLinkAccessLevelTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "viewer".
///
/// Description of the "viewer" tag state: Users who use the link can view and
/// comment on the content.
///
/// @return An initialized instance.
///
- (instancetype)initWithViewer;

///
/// Initializes union class with tag state of "editor".
///
/// Description of the "editor" tag state: Users who use the link can edit, view
/// and comment on the content. Note not all file types support edit links yet.
///
/// @return An initialized instance.
///
- (instancetype)initWithEditor;

///
/// Initializes union class with tag state of "max".
///
/// Description of the "max" tag state: Request for the maximum access level you
/// can set the link to.
///
/// @return An initialized instance.
///
- (instancetype)initWithMax;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "viewer".
///
/// @return Whether the union's current tag state has value "viewer".
///
- (BOOL)isViewer;

///
/// Retrieves whether the union's current tag state has value "editor".
///
/// @return Whether the union's current tag state has value "editor".
///
- (BOOL)isEditor;

///
/// Retrieves whether the union's current tag state has value "max".
///
/// @return Whether the union's current tag state has value "max".
///
- (BOOL)isMax;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGRequestedLinkAccessLevel` union.
///
@interface DBSHARINGRequestedLinkAccessLevelSerializer : NSObject

///
/// Serializes `DBSHARINGRequestedLinkAccessLevel` instances.
///
/// @param instance An instance of the `DBSHARINGRequestedLinkAccessLevel` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGRequestedLinkAccessLevel` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGRequestedLinkAccessLevel *)instance;

///
/// Deserializes `DBSHARINGRequestedLinkAccessLevel` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGRequestedLinkAccessLevel` API object.
///
/// @return An instantiation of the `DBSHARINGRequestedLinkAccessLevel` object.
///
+ (DBSHARINGRequestedLinkAccessLevel *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
