///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGMemberAction;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberAction` union.
///
/// Actions that may be taken on members of a shared folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGMemberAction : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGMemberActionTag` enum type represents the possible tag states
/// with which the `DBSHARINGMemberAction` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGMemberActionTag){
    /// Allow the member to keep a copy of the folder when removing.
    DBSHARINGMemberActionLeaveACopy,

    /// Make the member an editor of the folder.
    DBSHARINGMemberActionMakeEditor,

    /// Make the member an owner of the folder.
    DBSHARINGMemberActionMakeOwner,

    /// Make the member a viewer of the folder.
    DBSHARINGMemberActionMakeViewer,

    /// Make the member a viewer of the folder without commenting permissions.
    DBSHARINGMemberActionMakeViewerNoComment,

    /// Remove the member from the folder.
    DBSHARINGMemberActionRemove,

    /// (no description).
    DBSHARINGMemberActionOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGMemberActionTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "leave_a_copy".
///
/// Description of the "leave_a_copy" tag state: Allow the member to keep a copy
/// of the folder when removing.
///
/// @return An initialized instance.
///
- (instancetype)initWithLeaveACopy;

///
/// Initializes union class with tag state of "make_editor".
///
/// Description of the "make_editor" tag state: Make the member an editor of the
/// folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithMakeEditor;

///
/// Initializes union class with tag state of "make_owner".
///
/// Description of the "make_owner" tag state: Make the member an owner of the
/// folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithMakeOwner;

///
/// Initializes union class with tag state of "make_viewer".
///
/// Description of the "make_viewer" tag state: Make the member a viewer of the
/// folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithMakeViewer;

///
/// Initializes union class with tag state of "make_viewer_no_comment".
///
/// Description of the "make_viewer_no_comment" tag state: Make the member a
/// viewer of the folder without commenting permissions.
///
/// @return An initialized instance.
///
- (instancetype)initWithMakeViewerNoComment;

///
/// Initializes union class with tag state of "remove".
///
/// Description of the "remove" tag state: Remove the member from the folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemove;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "leave_a_copy".
///
/// @return Whether the union's current tag state has value "leave_a_copy".
///
- (BOOL)isLeaveACopy;

///
/// Retrieves whether the union's current tag state has value "make_editor".
///
/// @return Whether the union's current tag state has value "make_editor".
///
- (BOOL)isMakeEditor;

///
/// Retrieves whether the union's current tag state has value "make_owner".
///
/// @return Whether the union's current tag state has value "make_owner".
///
- (BOOL)isMakeOwner;

///
/// Retrieves whether the union's current tag state has value "make_viewer".
///
/// @return Whether the union's current tag state has value "make_viewer".
///
- (BOOL)isMakeViewer;

///
/// Retrieves whether the union's current tag state has value
/// "make_viewer_no_comment".
///
/// @return Whether the union's current tag state has value
/// "make_viewer_no_comment".
///
- (BOOL)isMakeViewerNoComment;

///
/// Retrieves whether the union's current tag state has value "remove".
///
/// @return Whether the union's current tag state has value "remove".
///
- (BOOL)isRemove;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGMemberAction` union.
///
@interface DBSHARINGMemberActionSerializer : NSObject

///
/// Serializes `DBSHARINGMemberAction` instances.
///
/// @param instance An instance of the `DBSHARINGMemberAction` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGMemberAction` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGMemberAction *)instance;

///
/// Deserializes `DBSHARINGMemberAction` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGMemberAction` API object.
///
/// @return An instantiation of the `DBSHARINGMemberAction` object.
///
+ (DBSHARINGMemberAction *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
