///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAccessLevel;
@class DBSHARINGChangeFileMemberAccessArgs;
@class DBSHARINGMemberSelector;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ChangeFileMemberAccessArgs` struct.
///
/// Arguments for `changeFileMemberAccess`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGChangeFileMemberAccessArgs : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// File for which we are changing a member's access.
@property (nonatomic, readonly, copy) NSString *file;

/// The member whose access we are changing.
@property (nonatomic, readonly) DBSHARINGMemberSelector *member;

/// The new access level for the member.
@property (nonatomic, readonly) DBSHARINGAccessLevel *accessLevel;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param file File for which we are changing a member's access.
/// @param member The member whose access we are changing.
/// @param accessLevel The new access level for the member.
///
/// @return An initialized instance.
///
- (instancetype)initWithFile:(NSString *)file
                      member:(DBSHARINGMemberSelector *)member
                 accessLevel:(DBSHARINGAccessLevel *)accessLevel;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ChangeFileMemberAccessArgs` struct.
///
@interface DBSHARINGChangeFileMemberAccessArgsSerializer : NSObject

///
/// Serializes `DBSHARINGChangeFileMemberAccessArgs` instances.
///
/// @param instance An instance of the `DBSHARINGChangeFileMemberAccessArgs` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGChangeFileMemberAccessArgs` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGChangeFileMemberAccessArgs *)instance;

///
/// Deserializes `DBSHARINGChangeFileMemberAccessArgs` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGChangeFileMemberAccessArgs` API object.
///
/// @return An instantiation of the `DBSHARINGChangeFileMemberAccessArgs`
/// object.
///
+ (DBSHARINGChangeFileMemberAccessArgs *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
