///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBPAPERListPaperDocsArgs;
@class DBPAPERListPaperDocsFilterBy;
@class DBPAPERListPaperDocsSortBy;
@class DBPAPERListPaperDocsSortOrder;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListPaperDocsArgs` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBPAPERListPaperDocsArgs : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Allows user to specify how the Paper docs should be filtered.
@property (nonatomic, readonly) DBPAPERListPaperDocsFilterBy *filterBy;

/// Allows user to specify how the Paper docs should be sorted.
@property (nonatomic, readonly) DBPAPERListPaperDocsSortBy *sortBy;

/// Allows user to specify the sort order of the result.
@property (nonatomic, readonly) DBPAPERListPaperDocsSortOrder *sortOrder;

/// Size limit per batch. The maximum number of docs that can be retrieved per
/// batch is 1000. Higher value results in invalid arguments error.
@property (nonatomic, readonly) NSNumber *limit;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param filterBy Allows user to specify how the Paper docs should be
/// filtered.
/// @param sortBy Allows user to specify how the Paper docs should be sorted.
/// @param sortOrder Allows user to specify the sort order of the result.
/// @param limit Size limit per batch. The maximum number of docs that can be
/// retrieved per batch is 1000. Higher value results in invalid arguments
/// error.
///
/// @return An initialized instance.
///
- (instancetype)initWithFilterBy:(nullable DBPAPERListPaperDocsFilterBy *)filterBy
                          sortBy:(nullable DBPAPERListPaperDocsSortBy *)sortBy
                       sortOrder:(nullable DBPAPERListPaperDocsSortOrder *)sortOrder
                           limit:(nullable NSNumber *)limit;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListPaperDocsArgs` struct.
///
@interface DBPAPERListPaperDocsArgsSerializer : NSObject

///
/// Serializes `DBPAPERListPaperDocsArgs` instances.
///
/// @param instance An instance of the `DBPAPERListPaperDocsArgs` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBPAPERListPaperDocsArgs` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBPAPERListPaperDocsArgs *)instance;

///
/// Deserializes `DBPAPERListPaperDocsArgs` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBPAPERListPaperDocsArgs` API object.
///
/// @return An instantiation of the `DBPAPERListPaperDocsArgs` object.
///
+ (DBPAPERListPaperDocsArgs *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
