///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESWriteConflictError;
@class DBFILESWriteError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `WriteError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESWriteError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESWriteErrorTag` enum type represents the possible tag states with
/// which the `DBFILESWriteError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESWriteErrorTag){
    /// The given path does not satisfy the required path format. Please refer
    /// to the Path formats documentation
    /// https://www.dropbox.com/developers/documentation/http/documentation#path-formats
    /// for more information.
    DBFILESWriteErrorMalformedPath,

    /// Couldn't write to the target path because there was something in the
    /// way.
    DBFILESWriteErrorConflict,

    /// The user doesn't have permissions to write to the target location.
    DBFILESWriteErrorNoWritePermission,

    /// The user doesn't have enough available space (bytes) to write more data.
    DBFILESWriteErrorInsufficientSpace,

    /// Dropbox will not save the file or folder because of its name.
    DBFILESWriteErrorDisallowedName,

    /// This endpoint cannot move or delete team folders.
    DBFILESWriteErrorTeamFolder,

    /// This file operation is not allowed at this path.
    DBFILESWriteErrorOperationSuppressed,

    /// There are too many write operations in user's Dropbox. Please retry this
    /// request.
    DBFILESWriteErrorTooManyWriteOperations,

    /// (no description).
    DBFILESWriteErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESWriteErrorTag tag;

/// The given path does not satisfy the required path format. Please refer to
/// the Path formats documentation
/// https://www.dropbox.com/developers/documentation/http/documentation#path-formats
/// for more information. @note Ensure the `isMalformedPath` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy, nullable) NSString *malformedPath;

/// Couldn't write to the target path because there was something in the way.
/// @note Ensure the `isConflict` method returns true before accessing,
/// otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESWriteConflictError *conflict;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "malformed_path".
///
/// Description of the "malformed_path" tag state: The given path does not
/// satisfy the required path format. Please refer to the Path formats
/// documentation
/// https://www.dropbox.com/developers/documentation/http/documentation#path-formats
/// for more information.
///
/// @param malformedPath The given path does not satisfy the required path
/// format. Please refer to the Path formats documentation
/// https://www.dropbox.com/developers/documentation/http/documentation#path-formats
/// for more information.
///
/// @return An initialized instance.
///
- (instancetype)initWithMalformedPath:(nullable NSString *)malformedPath;

///
/// Initializes union class with tag state of "conflict".
///
/// Description of the "conflict" tag state: Couldn't write to the target path
/// because there was something in the way.
///
/// @param conflict Couldn't write to the target path because there was
/// something in the way.
///
/// @return An initialized instance.
///
- (instancetype)initWithConflict:(DBFILESWriteConflictError *)conflict;

///
/// Initializes union class with tag state of "no_write_permission".
///
/// Description of the "no_write_permission" tag state: The user doesn't have
/// permissions to write to the target location.
///
/// @return An initialized instance.
///
- (instancetype)initWithNoWritePermission;

///
/// Initializes union class with tag state of "insufficient_space".
///
/// Description of the "insufficient_space" tag state: The user doesn't have
/// enough available space (bytes) to write more data.
///
/// @return An initialized instance.
///
- (instancetype)initWithInsufficientSpace;

///
/// Initializes union class with tag state of "disallowed_name".
///
/// Description of the "disallowed_name" tag state: Dropbox will not save the
/// file or folder because of its name.
///
/// @return An initialized instance.
///
- (instancetype)initWithDisallowedName;

///
/// Initializes union class with tag state of "team_folder".
///
/// Description of the "team_folder" tag state: This endpoint cannot move or
/// delete team folders.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolder;

///
/// Initializes union class with tag state of "operation_suppressed".
///
/// Description of the "operation_suppressed" tag state: This file operation is
/// not allowed at this path.
///
/// @return An initialized instance.
///
- (instancetype)initWithOperationSuppressed;

///
/// Initializes union class with tag state of "too_many_write_operations".
///
/// Description of the "too_many_write_operations" tag state: There are too many
/// write operations in user's Dropbox. Please retry this request.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyWriteOperations;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "malformed_path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `malformedPath` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "malformed_path".
///
- (BOOL)isMalformedPath;

///
/// Retrieves whether the union's current tag state has value "conflict".
///
/// @note Call this method and ensure it returns true before accessing the
/// `conflict` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "conflict".
///
- (BOOL)isConflict;

///
/// Retrieves whether the union's current tag state has value
/// "no_write_permission".
///
/// @return Whether the union's current tag state has value
/// "no_write_permission".
///
- (BOOL)isNoWritePermission;

///
/// Retrieves whether the union's current tag state has value
/// "insufficient_space".
///
/// @return Whether the union's current tag state has value
/// "insufficient_space".
///
- (BOOL)isInsufficientSpace;

///
/// Retrieves whether the union's current tag state has value "disallowed_name".
///
/// @return Whether the union's current tag state has value "disallowed_name".
///
- (BOOL)isDisallowedName;

///
/// Retrieves whether the union's current tag state has value "team_folder".
///
/// @return Whether the union's current tag state has value "team_folder".
///
- (BOOL)isTeamFolder;

///
/// Retrieves whether the union's current tag state has value
/// "operation_suppressed".
///
/// @return Whether the union's current tag state has value
/// "operation_suppressed".
///
- (BOOL)isOperationSuppressed;

///
/// Retrieves whether the union's current tag state has value
/// "too_many_write_operations".
///
/// @return Whether the union's current tag state has value
/// "too_many_write_operations".
///
- (BOOL)isTooManyWriteOperations;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESWriteError` union.
///
@interface DBFILESWriteErrorSerializer : NSObject

///
/// Serializes `DBFILESWriteError` instances.
///
/// @param instance An instance of the `DBFILESWriteError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESWriteError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESWriteError *)instance;

///
/// Deserializes `DBFILESWriteError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESWriteError` API object.
///
/// @return An instantiation of the `DBFILESWriteError` object.
///
+ (DBFILESWriteError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
