///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESLookupError;
@class DBFILESThumbnailError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ThumbnailError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESThumbnailError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESThumbnailErrorTag` enum type represents the possible tag states
/// with which the `DBFILESThumbnailError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESThumbnailErrorTag){
    /// An error occurs when downloading metadata for the image.
    DBFILESThumbnailErrorPath,

    /// The file extension doesn't allow conversion to a thumbnail.
    DBFILESThumbnailErrorUnsupportedExtension,

    /// The image cannot be converted to a thumbnail.
    DBFILESThumbnailErrorUnsupportedImage,

    /// An error occurs during thumbnail conversion.
    DBFILESThumbnailErrorConversionError,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESThumbnailErrorTag tag;

/// An error occurs when downloading metadata for the image. @note Ensure the
/// `isPath` method returns true before accessing, otherwise a runtime exception
/// will be raised.
@property (nonatomic, readonly) DBFILESLookupError *path;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "path".
///
/// Description of the "path" tag state: An error occurs when downloading
/// metadata for the image.
///
/// @param path An error occurs when downloading metadata for the image.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBFILESLookupError *)path;

///
/// Initializes union class with tag state of "unsupported_extension".
///
/// Description of the "unsupported_extension" tag state: The file extension
/// doesn't allow conversion to a thumbnail.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnsupportedExtension;

///
/// Initializes union class with tag state of "unsupported_image".
///
/// Description of the "unsupported_image" tag state: The image cannot be
/// converted to a thumbnail.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnsupportedImage;

///
/// Initializes union class with tag state of "conversion_error".
///
/// Description of the "conversion_error" tag state: An error occurs during
/// thumbnail conversion.
///
/// @return An initialized instance.
///
- (instancetype)initWithConversionError;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `path` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value
/// "unsupported_extension".
///
/// @return Whether the union's current tag state has value
/// "unsupported_extension".
///
- (BOOL)isUnsupportedExtension;

///
/// Retrieves whether the union's current tag state has value
/// "unsupported_image".
///
/// @return Whether the union's current tag state has value "unsupported_image".
///
- (BOOL)isUnsupportedImage;

///
/// Retrieves whether the union's current tag state has value
/// "conversion_error".
///
/// @return Whether the union's current tag state has value "conversion_error".
///
- (BOOL)isConversionError;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESThumbnailError` union.
///
@interface DBFILESThumbnailErrorSerializer : NSObject

///
/// Serializes `DBFILESThumbnailError` instances.
///
/// @param instance An instance of the `DBFILESThumbnailError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESThumbnailError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailError *)instance;

///
/// Deserializes `DBFILESThumbnailError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESThumbnailError` API object.
///
/// @return An instantiation of the `DBFILESThumbnailError` object.
///
+ (DBFILESThumbnailError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
