///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESSharedLink;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedLink` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSharedLink : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Shared link url.
@property (nonatomic, readonly, copy) NSString *url;

/// Password for the shared link.
@property (nonatomic, readonly, copy, nullable) NSString *password;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param url Shared link url.
/// @param password Password for the shared link.
///
/// @return An initialized instance.
///
- (instancetype)initWithUrl:(NSString *)url password:(nullable NSString *)password;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param url Shared link url.
///
/// @return An initialized instance.
///
- (instancetype)initWithUrl:(NSString *)url;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedLink` struct.
///
@interface DBFILESSharedLinkSerializer : NSObject

///
/// Serializes `DBFILESSharedLink` instances.
///
/// @param instance An instance of the `DBFILESSharedLink` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSharedLink` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSharedLink *)instance;

///
/// Deserializes `DBFILESSharedLink` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSharedLink` API object.
///
/// @return An instantiation of the `DBFILESSharedLink` object.
///
+ (DBFILESSharedLink *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
