///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESHighlightSpan;
@class DBFILESMetadataV2;
@class DBFILESSearchMatchTypeV2;
@class DBFILESSearchMatchV2;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SearchMatchV2` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSearchMatchV2 : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The metadata for the matched file or folder.
@property (nonatomic, readonly) DBFILESMetadataV2 *metadata;

/// The type of the match.
@property (nonatomic, readonly, nullable) DBFILESSearchMatchTypeV2 *matchType;

/// The list of HighlightSpan determines which parts of the file title should be
/// highlighted.
@property (nonatomic, readonly, nullable) NSArray<DBFILESHighlightSpan *> *highlightSpans;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param metadata The metadata for the matched file or folder.
/// @param matchType The type of the match.
/// @param highlightSpans The list of HighlightSpan determines which parts of
/// the file title should be highlighted.
///
/// @return An initialized instance.
///
- (instancetype)initWithMetadata:(DBFILESMetadataV2 *)metadata
                       matchType:(nullable DBFILESSearchMatchTypeV2 *)matchType
                  highlightSpans:(nullable NSArray<DBFILESHighlightSpan *> *)highlightSpans;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param metadata The metadata for the matched file or folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithMetadata:(DBFILESMetadataV2 *)metadata;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SearchMatchV2` struct.
///
@interface DBFILESSearchMatchV2Serializer : NSObject

///
/// Serializes `DBFILESSearchMatchV2` instances.
///
/// @param instance An instance of the `DBFILESSearchMatchV2` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSearchMatchV2` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMatchV2 *)instance;

///
/// Deserializes `DBFILESSearchMatchV2` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSearchMatchV2` API object.
///
/// @return An instantiation of the `DBFILESSearchMatchV2` object.
///
+ (DBFILESSearchMatchV2 *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
