///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESFileMetadata;
@class DBFILESMinimalFileLinkMetadata;
@class DBFILESPreviewResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PreviewResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESPreviewResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Metadata corresponding to the file received as an argument. Will be
/// populated if the endpoint is called with a path (ReadPath).
@property (nonatomic, readonly, nullable) DBFILESFileMetadata *fileMetadata;

/// Minimal metadata corresponding to the file received as an argument. Will be
/// populated if the endpoint is called using a shared link
/// (SharedLinkFileInfo).
@property (nonatomic, readonly, nullable) DBFILESMinimalFileLinkMetadata *linkMetadata;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param fileMetadata Metadata corresponding to the file received as an
/// argument. Will be populated if the endpoint is called with a path
/// (ReadPath).
/// @param linkMetadata Minimal metadata corresponding to the file received as
/// an argument. Will be populated if the endpoint is called using a shared link
/// (SharedLinkFileInfo).
///
/// @return An initialized instance.
///
- (instancetype)initWithFileMetadata:(nullable DBFILESFileMetadata *)fileMetadata
                        linkMetadata:(nullable DBFILESMinimalFileLinkMetadata *)linkMetadata;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PreviewResult` struct.
///
@interface DBFILESPreviewResultSerializer : NSObject

///
/// Serializes `DBFILESPreviewResult` instances.
///
/// @param instance An instance of the `DBFILESPreviewResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESPreviewResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESPreviewResult *)instance;

///
/// Deserializes `DBFILESPreviewResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESPreviewResult` API object.
///
/// @return An instantiation of the `DBFILESPreviewResult` object.
///
+ (DBFILESPreviewResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
