///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESFileMetadata;
@class DBFILESListRevisionsResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListRevisionsResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESListRevisionsResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// If the file identified by the latest revision in the response is either
/// deleted or moved.
@property (nonatomic, readonly) NSNumber *isDeleted;

/// The time of deletion if the file was deleted.
@property (nonatomic, readonly, nullable) NSDate *serverDeleted;

/// The revisions for the file. Only revisions that are not deleted will show up
/// here.
@property (nonatomic, readonly) NSArray<DBFILESFileMetadata *> *entries;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param isDeleted If the file identified by the latest revision in the
/// response is either deleted or moved.
/// @param entries The revisions for the file. Only revisions that are not
/// deleted will show up here.
/// @param serverDeleted The time of deletion if the file was deleted.
///
/// @return An initialized instance.
///
- (instancetype)initWithIsDeleted:(NSNumber *)isDeleted
                          entries:(NSArray<DBFILESFileMetadata *> *)entries
                    serverDeleted:(nullable NSDate *)serverDeleted;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param isDeleted If the file identified by the latest revision in the
/// response is either deleted or moved.
/// @param entries The revisions for the file. Only revisions that are not
/// deleted will show up here.
///
/// @return An initialized instance.
///
- (instancetype)initWithIsDeleted:(NSNumber *)isDeleted entries:(NSArray<DBFILESFileMetadata *> *)entries;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListRevisionsResult` struct.
///
@interface DBFILESListRevisionsResultSerializer : NSObject

///
/// Serializes `DBFILESListRevisionsResult` instances.
///
/// @param instance An instance of the `DBFILESListRevisionsResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESListRevisionsResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESListRevisionsResult *)instance;

///
/// Deserializes `DBFILESListRevisionsResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESListRevisionsResult` API object.
///
/// @return An instantiation of the `DBFILESListRevisionsResult` object.
///
+ (DBFILESListRevisionsResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
