///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESHighlightSpan;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `HighlightSpan` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESHighlightSpan : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// String to be determined whether it should be highlighted or not.
@property (nonatomic, readonly, copy) NSString *highlightStr;

/// The string should be highlighted or not.
@property (nonatomic, readonly) NSNumber *isHighlighted;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param highlightStr String to be determined whether it should be highlighted
/// or not.
/// @param isHighlighted The string should be highlighted or not.
///
/// @return An initialized instance.
///
- (instancetype)initWithHighlightStr:(NSString *)highlightStr isHighlighted:(NSNumber *)isHighlighted;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `HighlightSpan` struct.
///
@interface DBFILESHighlightSpanSerializer : NSObject

///
/// Serializes `DBFILESHighlightSpan` instances.
///
/// @param instance An instance of the `DBFILESHighlightSpan` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESHighlightSpan` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESHighlightSpan *)instance;

///
/// Deserializes `DBFILESHighlightSpan` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESHighlightSpan` API object.
///
/// @return An instantiation of the `DBFILESHighlightSpan` object.
///
+ (DBFILESHighlightSpan *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
