///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESFileStatus;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FileStatus` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESFileStatus : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESFileStatusTag` enum type represents the possible tag states with
/// which the `DBFILESFileStatus` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESFileStatusTag){
    /// (no description).
    DBFILESFileStatusActive,

    /// (no description).
    DBFILESFileStatusDeleted,

    /// (no description).
    DBFILESFileStatusOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESFileStatusTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "active".
///
/// @return An initialized instance.
///
- (instancetype)initWithActive;

///
/// Initializes union class with tag state of "deleted".
///
/// @return An initialized instance.
///
- (instancetype)initWithDeleted;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "active".
///
/// @return Whether the union's current tag state has value "active".
///
- (BOOL)isActive;

///
/// Retrieves whether the union's current tag state has value "deleted".
///
/// @return Whether the union's current tag state has value "deleted".
///
- (BOOL)isDeleted;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESFileStatus` union.
///
@interface DBFILESFileStatusSerializer : NSObject

///
/// Serializes `DBFILESFileStatus` instances.
///
/// @param instance An instance of the `DBFILESFileStatus` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESFileStatus` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESFileStatus *)instance;

///
/// Deserializes `DBFILESFileStatus` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESFileStatus` API object.
///
/// @return An instantiation of the `DBFILESFileStatus` object.
///
+ (DBFILESFileStatus *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
