///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESPropertyFieldTemplate;
@class DBFILEPROPERTIESUpdateTemplateArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UpdateTemplateArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEPROPERTIESUpdateTemplateArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// An identifier for template added by  See `templatesAddForUser` or
/// `templatesAddForTeam`.
@property (nonatomic, readonly, copy) NSString *templateId;

/// A display name for the template. template names can be up to 256 bytes.
@property (nonatomic, readonly, copy, nullable) NSString *name;

/// Description for the new template. Template descriptions can be up to 1024
/// bytes.
@property (nonatomic, readonly, copy, nullable) NSString *description_;

/// Property field templates to be added to the group template. There can be up
/// to 32 properties in a single template.
@property (nonatomic, readonly, nullable) NSArray<DBFILEPROPERTIESPropertyFieldTemplate *> *addFields;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param templateId An identifier for template added by  See
/// `templatesAddForUser` or `templatesAddForTeam`.
/// @param name A display name for the template. template names can be up to 256
/// bytes.
/// @param description_ Description for the new template. Template descriptions
/// can be up to 1024 bytes.
/// @param addFields Property field templates to be added to the group template.
/// There can be up to 32 properties in a single template.
///
/// @return An initialized instance.
///
- (instancetype)initWithTemplateId:(NSString *)templateId
                              name:(nullable NSString *)name
                      description_:(nullable NSString *)description_
                         addFields:(nullable NSArray<DBFILEPROPERTIESPropertyFieldTemplate *> *)addFields;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param templateId An identifier for template added by  See
/// `templatesAddForUser` or `templatesAddForTeam`.
///
/// @return An initialized instance.
///
- (instancetype)initWithTemplateId:(NSString *)templateId;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `UpdateTemplateArg` struct.
///
@interface DBFILEPROPERTIESUpdateTemplateArgSerializer : NSObject

///
/// Serializes `DBFILEPROPERTIESUpdateTemplateArg` instances.
///
/// @param instance An instance of the `DBFILEPROPERTIESUpdateTemplateArg` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESUpdateTemplateArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEPROPERTIESUpdateTemplateArg *)instance;

///
/// Deserializes `DBFILEPROPERTIESUpdateTemplateArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESUpdateTemplateArg` API object.
///
/// @return An instantiation of the `DBFILEPROPERTIESUpdateTemplateArg` object.
///
+ (DBFILEPROPERTIESUpdateTemplateArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
