///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESPropertyField;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PropertyField` struct.
///
/// Raw key/value data to be associated with a Dropbox file. Property fields are
/// added to Dropbox files as a PropertyGroup.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEPROPERTIESPropertyField : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Key of the property field associated with a file and template. Keys can be
/// up to 256 bytes.
@property (nonatomic, readonly, copy) NSString *name;

/// Value of the property field associated with a file and template. Values can
/// be up to 1024 bytes.
@property (nonatomic, readonly, copy) NSString *value;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param name Key of the property field associated with a file and template.
/// Keys can be up to 256 bytes.
/// @param value Value of the property field associated with a file and
/// template. Values can be up to 1024 bytes.
///
/// @return An initialized instance.
///
- (instancetype)initWithName:(NSString *)name value:(NSString *)value;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PropertyField` struct.
///
@interface DBFILEPROPERTIESPropertyFieldSerializer : NSObject

///
/// Serializes `DBFILEPROPERTIESPropertyField` instances.
///
/// @param instance An instance of the `DBFILEPROPERTIESPropertyField` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESPropertyField` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEPROPERTIESPropertyField *)instance;

///
/// Deserializes `DBFILEPROPERTIESPropertyField` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESPropertyField` API object.
///
/// @return An instantiation of the `DBFILEPROPERTIESPropertyField` object.
///
+ (DBFILEPROPERTIESPropertyField *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
