///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBAUTHTokenFromOAuth1Arg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TokenFromOAuth1Arg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBAUTHTokenFromOAuth1Arg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The supplied OAuth 1.0 access token.
@property (nonatomic, readonly, copy) NSString *oauth1Token;

/// The token secret associated with the supplied access token.
@property (nonatomic, readonly, copy) NSString *oauth1TokenSecret;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param oauth1Token The supplied OAuth 1.0 access token.
/// @param oauth1TokenSecret The token secret associated with the supplied
/// access token.
///
/// @return An initialized instance.
///
- (instancetype)initWithOauth1Token:(NSString *)oauth1Token oauth1TokenSecret:(NSString *)oauth1TokenSecret;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `TokenFromOAuth1Arg` struct.
///
@interface DBAUTHTokenFromOAuth1ArgSerializer : NSObject

///
/// Serializes `DBAUTHTokenFromOAuth1Arg` instances.
///
/// @param instance An instance of the `DBAUTHTokenFromOAuth1Arg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBAUTHTokenFromOAuth1Arg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBAUTHTokenFromOAuth1Arg *)instance;

///
/// Deserializes `DBAUTHTokenFromOAuth1Arg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBAUTHTokenFromOAuth1Arg` API object.
///
/// @return An instantiation of the `DBAUTHTokenFromOAuth1Arg` object.
///
+ (DBAUTHTokenFromOAuth1Arg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
